/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.awt;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;

public final class ShapeFactory {
    private ShapeFactory() {
    }

    public static Shape createRoundedSquare(double sideLength, double cornerRadius) {
        return ShapeFactory.createRoundedSquare(0.0, 0.0, sideLength, cornerRadius);
    }

    public static Shape createRoundedSquare(double x, double y, double sideLength, double cornerRadius) {
        return ShapeFactory.createRoundedRectangle(x, y, sideLength, sideLength, cornerRadius);
    }

    public static Shape createRoundedRectangle(double width, double height, double cornerRadius) {
        return ShapeFactory.createRoundedRectangle(0.0, 0.0, width, height, cornerRadius);
    }

    public static Shape createRoundedRectangle(double x, double y, double width, double height, double cornerRadius) {
        return new RoundRectangle2D.Double(x, y, width, height, cornerRadius, cornerRadius);
    }

    public static Shape createDiamond(double sideLength) {
        return ShapeFactory.createDiamond(sideLength, sideLength);
    }

    public static Shape createDiamond(double width, double height) {
        return ShapeFactory.createDiamond(0.0, 0.0, width, height);
    }

    public static Shape createDiamond(double x, double y, double width, double height) {
        return new Polygon(new int[]{(int)x, (int)(width / 2.0 + x), (int)(x + width), (int)(width / 2.0 + x)}, new int[]{(int)(height / 2.0 + y), (int)y, (int)(height / 2.0 + y), (int)(y + height)}, 4);
    }

    public static Shape createRoundedRectangle(double width, double height, double northWestRadius, double northEastRadius, double southEastRadius, double southWestRadius) {
        return ShapeFactory.createRoundedRectangle(0.0, 0.0, width, height, northWestRadius, northEastRadius, southEastRadius, southWestRadius);
    }

    public static Shape createRoundedRectangle(double x, double y, double width, double height, double northWestRadius, double northEastRadius, double southEastRadius, double southWestRadius) {
        double centerWidth = x + width / 2.0;
        double centerHeight = y + height / 2.0;
        double bottom = y + height;
        double right = x + width;
        Polygon nwQuadrant = new Polygon(new int[]{(int)x, (int)(x + northWestRadius), (int)(x + northWestRadius), (int)centerWidth, (int)centerWidth, (int)x}, new int[]{(int)(y + northWestRadius), (int)(y + northWestRadius), (int)y, (int)y, (int)centerHeight, (int)centerHeight}, 6);
        Polygon neQuadrant = new Polygon(new int[]{(int)centerWidth, (int)(right - northEastRadius), (int)(right - northEastRadius), (int)right, (int)right, (int)centerWidth}, new int[]{(int)y, (int)y, (int)(y + northEastRadius), (int)(y + northEastRadius), (int)centerHeight, (int)centerHeight}, 6);
        Polygon seQuadrant = new Polygon(new int[]{(int)centerWidth, (int)right, (int)right, (int)(right - southEastRadius), (int)(right - southEastRadius), (int)centerWidth}, new int[]{(int)centerHeight, (int)centerHeight, (int)(bottom - southEastRadius), (int)(bottom - southEastRadius), (int)bottom, (int)bottom}, 6);
        Polygon swQuadrant = new Polygon(new int[]{(int)x, (int)centerWidth, (int)centerWidth, (int)(x + southWestRadius), (int)(x + southWestRadius), (int)x}, new int[]{(int)centerHeight, (int)centerHeight, (int)bottom, (int)bottom, (int)(bottom - southWestRadius), (int)(bottom - southWestRadius)}, 6);
        double northWestDiameter = northWestRadius * 2.0;
        Ellipse2D.Double nwCorner = new Ellipse2D.Double(x, y, northWestDiameter, northWestDiameter);
        double northEastDiameter = northEastRadius * 2.0;
        Ellipse2D.Double neCorner = new Ellipse2D.Double(right - northEastDiameter, y, northEastDiameter, northEastDiameter);
        double southEastDiameter = southEastRadius * 2.0;
        Ellipse2D.Double seCorner = new Ellipse2D.Double(right - southEastDiameter, bottom - southEastDiameter, southEastDiameter, southEastDiameter);
        double southWestDiameter = southWestRadius * 2.0;
        Ellipse2D.Double swCorner = new Ellipse2D.Double(x, bottom - southWestDiameter, southWestDiameter, southWestDiameter);
        Area area = new Area(nwQuadrant);
        area.add(new Area(neQuadrant));
        area.add(new Area(seQuadrant));
        area.add(new Area(swQuadrant));
        area.add(new Area(nwCorner));
        area.add(new Area(neCorner));
        area.add(new Area(seCorner));
        area.add(new Area(swCorner));
        return area;
    }
}

