/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans;

import com.jmorgan.beans.DynamicCastException;
import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.PropertyNotFoundException;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.DynamicProcess;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.util.Pair;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.comparator.AnyObjectComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public class DynamicBean
extends JMBean
implements Comparable<DynamicBean>,
Cloneable {
    private static final long serialVersionUID = 7650391385117446199L;
    private HashMap<String, Pair<String, Object>> properties = new HashMap();
    private ArrayList<String> sortOrder = new ArrayList();
    private HashMap<String, Object> methods;

    public DynamicBean() {
    }

    public DynamicBean(Object objectToMimic) {
        this();
        if (objectToMimic == null) {
            throw new NullPointerException("DynamicBean(Object objectToMimic): objectToMimic cannot be null.");
        }
        if (objectToMimic instanceof String) {
            this.setProperty("string", objectToMimic);
            return;
        }
        ArrayList<String> properties = BeanService.getPropertyNames(objectToMimic);
        for (String property : properties) {
            Object value = BeanService.getPropertyValue(objectToMimic, property);
            this.setProperty(property, value);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DynamicBean newBean = new DynamicBean();
        for (String property : this.properties.keySet()) {
            Object propertyValue = this.getProperty(property);
            if (propertyValue != null && propertyValue instanceof Cloneable) {
                MethodInvoker cloneInvoker = new MethodInvoker(propertyValue, "clone", new Object[0]);
                propertyValue = cloneInvoker.invoke();
            }
            newBean.setProperty(property, propertyValue);
        }
        return newBean;
    }

    public boolean hasProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public HashMap<String, Pair<String, Object>> getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap<String, Pair<String, Object>> properties) {
        this.getPropertyChangeSupport().firePropertyChange("all", true, false);
        this.properties = properties;
        if (this.sortOrder != null) {
            this.sortOrder.clear();
            this.sortOrder = new ArrayList<String>(properties.keySet());
        }
        this.getPropertyChangeSupport().firePropertyChange("all", false, true);
    }

    public ArrayList<String> getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(ArrayList<String> sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public boolean properyExists(String name) {
        return this.properties.get(name) != null;
    }

    public void setProperty(String name, Object value) {
        Pair<String, Object> oldMap;
        Object oldValue;
        if (!this.sortOrder.contains(name)) {
            this.sortOrder.add(name);
        }
        Object object = oldValue = (oldMap = this.properties.get(name)) == null ? null : (Object)oldMap.second;
        if (oldMap == null || oldValue == null && value != null || oldValue != null && value == null || oldValue != null && !oldValue.equals(value)) {
            this.properties.put(name, new Pair<String, Object>(name, value));
            if (oldMap == null) {
                this.getPropertyChangeSupport().firePropertyChange("property", null, name);
            }
            this.getPropertyChangeSupport().firePropertyChange(name, oldValue, value);
        }
    }

    public void setPropertyIfNotNull(String name, Object value) {
        if (value == null) {
            return;
        }
        this.setProperty(name, value);
    }

    public void removeProperty(String name) throws PropertyNotFoundException {
        Pair<String, Object> oldMap;
        if (this.sortOrder.contains(name)) {
            this.sortOrder.remove(name);
        }
        if ((oldMap = this.properties.remove(name)) == null) {
            throw new PropertyNotFoundException(name);
        }
        this.getPropertyChangeSupport().firePropertyChange(name, oldMap.second, null);
        this.getPropertyChangeSupport().firePropertyChange("property", name, null);
    }

    public <T> T getProperty(String name) throws PropertyNotFoundException {
        Pair<String, Object> value = this.properties.get(name);
        if (value == null) {
            throw new PropertyNotFoundException(name);
        }
        return (T)value.second;
    }

    public <T> T getProperty(String name, T valueIfNotExists) {
        Pair<String, Object> value = this.properties.get(name);
        if (value == null) {
            return valueIfNotExists;
        }
        return (T)value.second;
    }

    public void setMethod(String methodName, Object invoker) throws IllegalArgumentException {
        if (methodName == null || invoker == null) {
            return;
        }
        if (!(invoker instanceof MethodInvoker) && !(invoker instanceof DynamicProcess)) {
            throw new IllegalArgumentException("DynamicBean.setMethod(String methodName, Object invoker) requires an instance of either com.jmorgan.lang.MethodInvoker or com.jmorgan.lang.DynamicProcess as the invoker.");
        }
        if (this.methods == null) {
            this.methods = new HashMap();
        }
        this.methods.put(methodName, invoker);
    }

    public Object invokeMethod(String methodName) {
        Object invokerObject = this.methods.get(methodName);
        if (invokerObject instanceof MethodInvoker) {
            MethodInvoker invoker = (MethodInvoker)invokerObject;
            return invoker.invoke();
        }
        if (invokerObject instanceof DynamicProcess) {
            DynamicProcess invoker = (DynamicProcess)invokerObject;
            return invoker.invoke();
        }
        return null;
    }

    public Object invokeMethod(String methodName, Object ... methodArguments) {
        Object invokerObject = this.methods.get(methodName);
        if (invokerObject instanceof MethodInvoker) {
            MethodInvoker invoker = (MethodInvoker)invokerObject;
            invoker.setArguments(methodArguments);
            return invoker.invoke();
        }
        if (invokerObject instanceof DynamicProcess) {
            DynamicProcess invoker = (DynamicProcess)invokerObject;
            invoker.setProcessArguments(methodArguments);
            return invoker.invoke();
        }
        return null;
    }

    public void removeMethod(String methodName) {
    }

    public void setSortOrder(String[] propertyNames) {
        this.sortOrder = new ArrayList<String>(Arrays.asList(propertyNames));
    }

    public void setSortOrder(Collection<String> propertyNames) {
        this.sortOrder = new ArrayList<String>(propertyNames);
    }

    public boolean instanceOf(DynamicBean that) {
        if (that == null) {
            return false;
        }
        if (this.getPropertyCount() != that.getPropertyCount()) {
            return false;
        }
        for (String propertyName : this.getPropertyNames()) {
            try {
                Object thisValue = this.getProperty(propertyName);
                Object thatValue = that.getProperty(propertyName);
                if (thisValue == null || thatValue == null || thisValue.getClass().getName().equals(thatValue.getClass().getName())) continue;
                return false;
            }
            catch (PropertyNotFoundException pex) {
                return false;
            }
        }
        return true;
    }

    public <T> T toObject(T object) {
        if (object == null) {
            throw new NullPointerException("DynamicBean.toObject(Object object)");
        }
        if (object instanceof String && this.hasProperty("string")) {
            return this.getProperty("string");
        }
        Collection<String> theseProperties = this.getPropertyNames();
        ArrayList<String> propertyNames = BeanService.getMutablePropertyNames(object);
        for (String property : propertyNames) {
            for (String thisProperty : theseProperties) {
                if (!thisProperty.equals(property)) continue;
                T value = this.getProperty(thisProperty);
                BeanService.setPropertyValue(object, property, value);
            }
        }
        return object;
    }

    @Override
    public int compareTo(DynamicBean that) {
        if (this.equals(that)) {
            return 0;
        }
        if (!this.instanceOf(that)) {
            throw new DynamicCastException(this, that);
        }
        AnyObjectComparator comparator = new AnyObjectComparator(1);
        for (String propertyName : this.sortOrder) {
            Object thatValue;
            Object thisValue = this.getProperty(propertyName);
            int cmp = comparator.compare(thisValue, thatValue = that.getProperty(propertyName));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        Set<String> propertyNames = this.properties.keySet();
        return this.hashCodeOf(CollectionUtility.toArray(propertyNames));
    }

    public int hashCodeOf(String ... propertyNames) {
        int hashCode = 31;
        String[] stringArray = propertyNames;
        int n = propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            Object fieldValue = this.getProperty(propertyName);
            if (fieldValue == null) {
                hashCode *= BeanService.HASHCODE_PRIME;
            }
            if (fieldValue != this) {
                if (fieldValue.getClass().isEnum() || fieldValue.getClass().equals(DynamicBean.class)) {
                    hashCode = BeanService.HASHCODE_PRIME * hashCode + fieldValue.hashCode();
                } else if (fieldValue instanceof Collection) {
                    Collection collection = (Collection)fieldValue;
                    for (Object c : collection) {
                        hashCode = BeanService.HASHCODE_PRIME * hashCode + BeanService.getHashCode(c);
                    }
                } else if (fieldValue.getClass().isArray()) {
                    Object[] array;
                    Object[] objectArray = array = (Object[])fieldValue;
                    int n3 = array.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object a = objectArray[n4];
                        hashCode = BeanService.HASHCODE_PRIME * hashCode + BeanService.getHashCode(a);
                        ++n4;
                    }
                } else {
                    hashCode = BeanService.HASHCODE_PRIME * hashCode + BeanService.getHashCode(fieldValue);
                }
            }
            ++n2;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof DynamicBean) {
            DynamicBean that = (DynamicBean)o;
            if (!this.instanceOf(that)) {
                return false;
            }
            AnyObjectComparator comparator = new AnyObjectComparator(1);
            for (Pair<String, Object> thisValue : this.properties.values()) {
                Object thatValue = that.getProperty((String)thisValue.first);
                if (comparator.compare(thisValue.second, thatValue) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String property : this.sortOrder) {
            Pair<String, Object> value = this.properties.get(property);
            sb.append((String)value.first);
            sb.append('=');
            if (value.second == this) {
                System.err.printf("DynamicBean.toString(): Dynamic Bean property '%s' references itself\n", value.first);
                sb.append("*** Error Recursive Reference to Self ***");
            } else {
                sb.append(value.second);
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

