/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans;

import com.jmorgan.beans.JMBean;
import com.jmorgan.util.NumberUtility;
import com.jmorgan.util.StringUtility;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public class IPAddress
extends JMBean
implements Comparable<IPAddress> {
    private int[] octets = new int[4];
    private int subnetMask = 32;

    public static final String getByName(String hostName) {
        if (StringUtility.isEmpty(hostName)) {
            return null;
        }
        try {
            InetAddress address = InetAddress.getByName(hostName);
            return address.getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static final boolean isIPAddress(String ipAddress) {
        try {
            new IPAddress(ipAddress);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            return false;
        }
        return true;
    }

    public IPAddress() {
    }

    public IPAddress(int octet1, int octet2, int octet3, int octet4) {
        this(octet1, octet2, octet3, octet4, 32);
    }

    public IPAddress(int octet1, int octet2, int octet3, int octet4, int subnetMask) {
        this();
        this.setIPAddress(octet1, octet2, octet3, octet4, subnetMask);
    }

    public IPAddress(String ipAddress) {
        this();
        this.setIPAddress(ipAddress);
    }

    public void setIPAddress(int octet1, int octet2, int octet3, int octet4) {
        this.setIPAddress(octet1, octet2, octet3, octet4, 32);
    }

    public void setIPAddress(int octet1, int octet2, int octet3, int octet4, int subnetMask) {
        this.setOctet(0, octet1);
        this.setOctet(1, octet2);
        this.setOctet(2, octet3);
        this.setOctet(3, octet4);
        this.setSubnetMask(subnetMask);
    }

    public void setIPAddress(String ipAddress) throws IllegalArgumentException {
        String[] octetInfo;
        int subnetSeparator = ipAddress.indexOf("/");
        if (subnetSeparator > 0) {
            String[] ipInfo = ipAddress.split("/");
            if (ipInfo.length > 2) {
                throw new IllegalArgumentException("The given ip address [" + ipAddress + "] is not valid.");
            }
            ipAddress = ipInfo[0];
            String subnet = ipInfo[1];
            if (!NumberUtility.isInteger(subnet)) {
                throw new IllegalArgumentException("The given ip address [" + ipAddress + "] is not valid.");
            }
            this.setSubnetMask(Integer.parseInt(subnet));
        }
        if ((octetInfo = ipAddress.split("\\.")).length != 4) {
            throw new IllegalArgumentException("The given ip address [" + ipAddress + "] is not valid.");
        }
        int i = 0;
        while (i < octetInfo.length) {
            String octetValue = octetInfo[i];
            if (!NumberUtility.isInteger(octetValue)) {
                throw new IllegalArgumentException("The given ip address [" + ipAddress + "] is not valid.");
            }
            int octet = Integer.parseInt(octetValue);
            this.setOctet(i, octet);
            ++i;
        }
    }

    public boolean isLocalHost() {
        return this.octets[0] == 127 && this.octets[1] == 0 && this.octets[2] == 0 && this.octets[3] == 1;
    }

    public int getOctet(int index) {
        if (index < 0 || index > 3) {
            throw new IndexOutOfBoundsException(String.format("IPAddress.getOctet(index=%d):  Index out of range of 0-3", index));
        }
        return this.octets[index];
    }

    public void setOctet(int index, int value) {
        if (index < 0 || index > 3) {
            throw new IndexOutOfBoundsException(String.format("IPAddress.setOctet(index=%d, value=%d):  Index out of range of 0-3", index, value));
        }
        if (value < 0 || value > 255) {
            throw new IndexOutOfBoundsException(String.format("IPAddress.setOctet(index=%d, value=%d):  Value out of range of 0-255", index, value));
        }
        this.octets[index] = value;
    }

    public int getSubnetMask() {
        return this.subnetMask;
    }

    public void setSubnetMask(int subnetMask) {
        if (subnetMask < 0 || subnetMask > 32) {
            throw new IndexOutOfBoundsException(String.format("IPAddress.setSubnetMask(subnetMask=%d):  Subnetmask out of range of 0-32", subnetMask));
        }
        this.subnetMask = subnetMask;
    }

    @Override
    public int compareTo(IPAddress that) {
        if (this.equals(that)) {
            return 0;
        }
        int i = 0;
        while (i < this.octets.length) {
            int cmp = this.octets[i] - that.octets[i];
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return this.subnetMask - that.subnetMask;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.octets);
        result = 31 * result + this.subnetMask;
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof IPAddress) {
            IPAddress that = (IPAddress)o;
            return this.octets[0] == that.octets[0] && this.octets[1] == that.octets[1] && this.octets[2] == that.octets[2] && this.octets[3] == that.octets[3] && this.subnetMask == that.subnetMask;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%d.%d.%d.%d/%d", this.octets[0], this.octets[1], this.octets[2], this.octets[3], this.subnetMask);
    }
}

