/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans;

import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.beans.PropertyGetDelegate;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.ArrayUtility;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Objects;

public class JMBean
implements Serializable,
PropertyChangeNotifier {
    private static final long serialVersionUID = 6758868575534051711L;
    private transient PropertyChangeSupport propertyChangeSupport;
    private transient ArrayList<PropertyGetDelegate<?, ?>> propertyGetDelegates;
    private int hashCode;
    private String asString;
    private String toStringDelimiter;

    public JMBean() {
        this.setToStringDelimiter(", ");
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public String getToStringDelimiter() {
        return this.toStringDelimiter;
    }

    public void setToStringDelimiter(String toStringDelimiter) {
        this.toStringDelimiter = toStringDelimiter;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void handlePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void handlePropertyChange(String propertyName, char oldValue, char newValue) {
        if (oldValue != newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void handlePropertyChange(String propertyName, long oldValue, long newValue) {
        if (oldValue != newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void handlePropertyChange(String propertyName, double oldValue, double newValue) {
        if (oldValue != newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void handlePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (!this.areEqual(oldValue, newValue)) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void addPropertyGetDelegate(PropertyGetDelegate<?, ?> getDelegate) {
        if (getDelegate == null) {
            return;
        }
        if (this.getPropertyGetDelegates().contains(getDelegate)) {
            return;
        }
        this.propertyGetDelegates.add(getDelegate);
    }

    public PropertyGetDelegate<?, ?> getDelegateFor(String propertyName) {
        if (this.propertyGetDelegates == null || this.propertyGetDelegates.size() == 0) {
            return null;
        }
        for (PropertyGetDelegate<?, ?> getDelegate : this.propertyGetDelegates) {
            if (!getDelegate.isDelegateFor(propertyName)) continue;
            return getDelegate;
        }
        return null;
    }

    public void removePropertyGetDelegate(PropertyGetDelegate<?, ?> getDelegate) {
        if (getDelegate == null) {
            return;
        }
        this.propertyGetDelegates.remove(getDelegate);
    }

    protected ArrayList<PropertyGetDelegate<?, ?>> getPropertyGetDelegates() {
        if (this.propertyGetDelegates == null) {
            this.propertyGetDelegates = new ArrayList();
        }
        return this.propertyGetDelegates;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    protected boolean areEqual(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        boolean aIsArray = a.getClass().isArray();
        boolean bIsArray = b.getClass().isArray();
        if (aIsArray && !bIsArray) {
            return false;
        }
        if (!aIsArray && bIsArray) {
            return false;
        }
        if (aIsArray && bIsArray) {
            int bLength;
            boolean sameType = a.getClass().equals(b.getClass());
            if (!sameType) {
                return false;
            }
            int aLength = Array.getLength(a);
            if (aLength != (bLength = Array.getLength(b))) {
                return false;
            }
            int i = 0;
            while (i < aLength) {
                Object bValue;
                Object aValue = Array.get(a, i);
                if (!Objects.equals(aValue, bValue = Array.get(b, i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return a.equals(b);
    }

    protected boolean areEqualIgnoreCase(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        return a.equalsIgnoreCase(b);
    }

    protected int compareTo(Object that, String ... properties) {
        return BeanService.compareTo(this, that, properties);
    }

    protected int compare(Comparable a, Comparable b) {
        if (this.areEqual(a, b)) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    protected int compareIgnoreCase(String a, String b) {
        if (this.areEqualIgnoreCase(a, b)) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        return a.compareToIgnoreCase(b);
    }

    protected int compareForNull(Object a, Object b) {
        if (this.areEqual(a, b)) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        return 100;
    }

    public int hashCode() {
        this.hashCode = BeanService.getHashCode(this);
        return this.hashCode;
    }

    public int hashCode(String ... properties) {
        return BeanService.hashCode(this, properties);
    }

    protected int hashCode(int superResult, String ... properties) {
        int thisHashCode = this.hashCode(properties);
        return 31 * superResult + thisHashCode;
    }

    protected boolean equals(Object that, String ... properties) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (this.getClass().isAssignableFrom(that.getClass()) || that.getClass().isAssignableFrom(this.getClass())) {
            if (ArrayUtility.isEmpty(properties)) {
                ArrayList<String> propertyList = BeanService.getPropertyNames(this);
                properties = propertyList.toArray(new String[propertyList.size()]);
            }
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                Object thatProperty;
                String propertyName = stringArray[n2];
                Object thisProperty = BeanService.getPropertyValue(this, propertyName);
                if (!this.areEqual(thisProperty, thatProperty = BeanService.getPropertyValue(that, propertyName))) {
                    return false;
                }
                ++n2;
            }
        } else {
            return false;
        }
        return true;
    }

    public String toString(String ... properties) {
        if (ArrayUtility.isEmpty(properties)) {
            return BeanService.toString(this, this.toStringDelimiter);
        }
        return BeanService.toString(this, this.toStringDelimiter, properties);
    }

    public String toString() {
        this.asString = BeanService.toString(this, this.toStringDelimiter);
        return this.asString;
    }
}

