/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans.util;

import com.jmorgan.beans.util.BeanPropertyMap;
import com.jmorgan.beans.util.BeanService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BeanToBeanPropertyMap<S, T>
extends BeanPropertyMap<T> {
    private S sourceBean;

    public BeanToBeanPropertyMap(S source, T bean) {
        this(source, bean, false);
    }

    public BeanToBeanPropertyMap(S source, T bean, boolean debug) {
        super(bean, debug);
        this.setSourceBean(source);
    }

    public BeanToBeanPropertyMap(S source, T bean, Map<String, String> defaultPropertyNameMap) {
        this(source, bean, defaultPropertyNameMap, false);
    }

    public BeanToBeanPropertyMap(S source, T bean, Map<String, String> defaultPropertyNameMap, boolean debug) {
        this(source, bean, debug);
        this.setDefaultPropertyNameMap(defaultPropertyNameMap);
    }

    public S getSourceBean() {
        return this.sourceBean;
    }

    public void setSourceBean(S sourceBean) {
        this.sourceBean = sourceBean;
    }

    @Override
    public Map<String, Object> getMap() {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        ArrayList<String> properties = BeanService.getPropertyNames(this.sourceBean);
        for (String propertyName : properties) {
            propertyMap.put(propertyName, BeanService.getPropertyValue(this.sourceBean, propertyName));
        }
        return propertyMap;
    }
}

