/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans.util;

import com.jmorgan.beans.util.BeanPropertyMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesBeanMap<T>
extends BeanPropertyMap<T> {
    private File propertiesFile;

    public PropertiesBeanMap(File propertiesFile, T bean) {
        this(propertiesFile, bean, false);
    }

    public PropertiesBeanMap(File propertiesFile, T bean, boolean debug) {
        super(bean, debug);
        this.setPropertiesFile(propertiesFile);
        this.loadBean();
    }

    public PropertiesBeanMap(File propertiesFile, T bean, Map<String, String> defaultPropertyNameMap) {
        this(propertiesFile, bean, defaultPropertyNameMap, false);
    }

    public PropertiesBeanMap(File propertiesFile, T bean, Map<String, String> defaultPropertyNameMap, boolean debug) {
        super(bean, defaultPropertyNameMap, debug);
        this.setPropertiesFile(propertiesFile);
        this.loadBean();
    }

    public PropertiesBeanMap(String propertiesFileName, T bean) {
        this(propertiesFileName, bean, false);
    }

    public PropertiesBeanMap(String propertiesFileName, T bean, boolean debug) {
        this(new File(propertiesFileName), bean, debug);
    }

    public PropertiesBeanMap(String propertiesFileName, T bean, Map<String, String> defaultPropertyNameMap) {
        this(propertiesFileName, bean, defaultPropertyNameMap, false);
    }

    public PropertiesBeanMap(String propertiesFileName, T bean, Map<String, String> defaultPropertyNameMap, boolean debug) {
        this(new File(propertiesFileName), bean, defaultPropertyNameMap, debug);
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    @Override
    public Map<String, Object> getMap() {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        Properties properties = new Properties();
        try {
            FileInputStream fin = new FileInputStream(this.propertiesFile);
            properties.load(fin);
            fin.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Object pKey : properties.keySet()) {
            String key = (String)pKey;
            Object value = properties.get(key);
            propertyMap.put(key, value);
            if (!this.isDebug()) continue;
            System.out.println("PropertiesBeanMap.getMap(): parameter=value: " + key + "=" + String.valueOf(value));
        }
        if (this.isDebug()) {
            System.out.println("PropertiesBeanMap.getMap(): Property Map Size: " + propertyMap.size());
        }
        return propertyMap;
    }
}

