/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans.util;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.IdentityHashMap;

public class PropertyChangeManager {
    private IdentityHashMap<Object, HashMap<String, Pair<Object, UniqueArrayList<PropertyChangeListener>>>> listenerData;
    private boolean running;

    public PropertyChangeManager() {
        this.clear();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener, Object target, String propertyName) throws NullPointerException, IllegalArgumentException {
        Pair<Object, UniqueArrayList<PropertyChangeListener>> propertyValue;
        PropertyChangeManager.checkParameters(listener, target, propertyName);
        HashMap<String, Pair<Object, UniqueArrayList<PropertyChangeListener>>> properties = this.listenerData.get(target);
        if (properties == null) {
            properties = new HashMap();
            this.listenerData.put(target, properties);
        }
        if ((propertyValue = properties.get(propertyName)) == null) {
            Object currentValue = BeanService.getPropertyValue(target, propertyName);
            UniqueArrayList listeners = new UniqueArrayList();
            propertyValue = new Pair(currentValue, listeners);
            properties.put(propertyName, propertyValue);
        }
        ((UniqueArrayList)propertyValue.second).add(listener);
        if (!this.running) {
            this.running = true;
            new AsynchMethodInvoker((Object)this, "checkProperties", 100);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener, Object target, String propertyName) throws NullPointerException, IllegalArgumentException {
        PropertyChangeManager.checkParameters(listener, target, propertyName);
        HashMap<String, Pair<Object, UniqueArrayList<PropertyChangeListener>>> properties = this.listenerData.get(target);
        if (properties == null) {
            return;
        }
        Pair<Object, UniqueArrayList<PropertyChangeListener>> listeners = properties.get(propertyName);
        if (listeners == null) {
            return;
        }
        if (!((UniqueArrayList)listeners.second).contains(listener)) {
            return;
        }
        ((UniqueArrayList)listeners.second).remove(listener);
        if (((UniqueArrayList)listeners.second).size() == 0) {
            properties.remove(propertyName);
            if (properties.size() == 0) {
                this.listenerData.remove(target);
                this.running = false;
            }
        }
    }

    private static void checkParameters(Object target) throws NullPointerException {
        if (target == null) {
            throw new NullPointerException("The value for target for PropertyChangeManager.addPropertyChangeListener() is not allowed to be null.");
        }
    }

    private static void checkParameters(Object target, String propertyName) throws NullPointerException, IllegalArgumentException {
        PropertyChangeManager.checkParameters(target);
        if (StringUtility.isEmpty(propertyName)) {
            throw new IllegalArgumentException("The value for propertyName for PropertyChangeManager.addPropertyChangeListener() is invalid.");
        }
    }

    private static void checkParameters(PropertyChangeListener listener, Object target, String propertyName) throws NullPointerException, IllegalArgumentException {
        if (listener == null) {
            throw new NullPointerException("The value for listener for PropertyChangeManager.addPropertyChangeListener() is not allowed to be null.");
        }
        PropertyChangeManager.checkParameters(target, propertyName);
    }

    public synchronized void clear() {
        this.listenerData = new IdentityHashMap();
        this.running = false;
    }

    public synchronized void clear(Object target) throws NullPointerException {
        PropertyChangeManager.checkParameters(target);
        HashMap<String, Pair<Object, UniqueArrayList<PropertyChangeListener>>> properties = this.listenerData.get(target);
        if (properties == null) {
            return;
        }
        properties.clear();
        this.listenerData.remove(target);
        this.running = false;
    }

    public synchronized void clear(Object target, String propertyName) throws NullPointerException, IllegalArgumentException {
        PropertyChangeManager.checkParameters(target, propertyName);
        HashMap<String, Pair<Object, UniqueArrayList<PropertyChangeListener>>> properties = this.listenerData.get(target);
        if (properties == null) {
            return;
        }
        Pair<Object, UniqueArrayList<PropertyChangeListener>> listeners = properties.get(propertyName);
        if (listeners == null) {
            return;
        }
        ((UniqueArrayList)listeners.second).clear();
        properties.remove(propertyName);
        if (properties.size() == 0) {
            this.listenerData.remove(target);
            this.running = false;
        }
    }

    @Reflected
    public synchronized void checkProperties() {
        for (Object target : this.listenerData.keySet()) {
            HashMap<String, Pair<Object, UniqueArrayList<PropertyChangeListener>>> properties = this.listenerData.get(target);
            for (String propertyName : properties.keySet()) {
                Object newValue = BeanService.getPropertyValue(target, propertyName);
                Pair<Object, UniqueArrayList<PropertyChangeListener>> listeners = properties.get(propertyName);
                Object oldValue = listeners.first;
                if (oldValue.equals(newValue)) continue;
                listeners.first = newValue;
                PropertyChangeEvent evt = new PropertyChangeEvent(target, propertyName, oldValue, newValue);
                for (PropertyChangeListener listener : (UniqueArrayList)listeners.second) {
                    new AsynchMethodInvoker((Object)listener, "propertyChange", (Object)evt);
                }
            }
        }
        if (this.running) {
            new AsynchMethodInvoker((Object)this, "checkProperties", 100);
        }
    }
}

