/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans.util;

import com.jmorgan.beans.util.DefaultDataTypeConverter;
import com.jmorgan.util.NumberUtility;
import com.jmorgan.util.StringUtility;

public class StringToBooleanConverter
extends DefaultDataTypeConverter<String, Boolean> {
    public StringToBooleanConverter() {
        this(false);
    }

    public StringToBooleanConverter(Boolean defaultIfNull) {
        super(defaultIfNull);
    }

    @Override
    public Boolean convert(String value) {
        if (StringUtility.isEmpty(value)) {
            return (Boolean)this.getDefaultIfNull();
        }
        String lcValueToCoerce = value.toLowerCase();
        if (lcValueToCoerce.equals("on")) {
            value = "true";
        } else if (lcValueToCoerce.equals("off")) {
            value = "false";
        } else if (lcValueToCoerce.equals("yes")) {
            value = "true";
        } else if (lcValueToCoerce.equals("no")) {
            value = "false";
        }
        if (NumberUtility.isNumber(lcValueToCoerce)) {
            double n = Double.parseDouble(lcValueToCoerce);
            value = n == 0.0 ? "false" : "true";
        }
        return Boolean.valueOf(value);
    }
}

