/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.graphics;

import com.jmorgan.util.Pair;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;

public abstract class AbstractGradientPainter {
    private Shape shape;
    private ArrayList<Pair<Float, Color>> colors = new ArrayList();
    private Point startingPoint = new Point(0, 0);
    private Point stoppingPoint = new Point(0, 0);

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        this.stoppingPoint = new Point(0, shape.getBounds().height);
    }

    public void addColor(Color color, float location) {
        if (color == null) {
            throw new IllegalArgumentException("AbstractGradientPainter.addColor(Color, Float):  The value for color cannot be null");
        }
        this.colors.add(new Pair<Float, Color>(new Float(location), color));
    }

    public void removeColor(Color color, float location) {
        Pair<Float, Color> badColor = this.findColor(color, location);
        if (badColor == null) {
            return;
        }
        this.colors.remove(badColor);
    }

    private Pair<Float, Color> findColor(Color color, float location) {
        if (color == null) {
            return null;
        }
        Pair<Float, Color> badColor = new Pair<Float, Color>(new Float(location), color);
        for (Pair<Float, Color> c : this.colors) {
            if (!c.equals(badColor)) continue;
            return c;
        }
        return null;
    }

    public Point getStartingPoint() {
        return this.startingPoint;
    }

    public void setStartingPoint(Point startingPoint) {
        this.startingPoint = startingPoint;
    }

    public Point getStoppingPoint() {
        return this.stoppingPoint;
    }

    public void setStoppingPoint(Point stoppingPoint) {
        this.stoppingPoint = stoppingPoint;
    }

    public void paint(Graphics2D graphics) {
        Collections.sort(this.colors);
        float[] stops = new float[this.colors.size()];
        Color[] colors = new Color[this.colors.size()];
        int i = 0;
        for (Pair<Float, Color> c : this.colors) {
            stops[i] = ((Float)c.first).floatValue();
            colors[i++] = (Color)c.second;
        }
        graphics.setPaint(this.getPaint(stops, colors));
        graphics.fill(this.shape);
    }

    public abstract Paint getPaint(float[] var1, Color[] var2);
}

