/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.graphics;

import com.jmorgan.io.CDataReader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BitmapInfoHeader {
    public static final int MONOCHROME = 1;
    public static final int COLORS_16 = 4;
    public static final int COLORS_256 = 8;
    public static final int COLORS_16M = 24;
    public static final int COMPRESSION_NONE = 0;
    public static final int COMPRESSION_RLE8 = 1;
    public static final int COMPRESSION_RLE4 = 2;
    private long thisSize;
    private long bitmapWidth;
    private long bitmapHeight;
    private int planes;
    private int bitsPerPixel;
    private long compressionType;
    private long imageSize;
    private long xPixelsPerMeter;
    private long yPixelsPerMeter;
    private long colorIndexesUsed;
    private long colorsImportant;

    public long getStructureSize() {
        return this.thisSize;
    }

    public long getBitmapWidth() {
        return this.bitmapWidth;
    }

    public long getBitmapHeight() {
        return this.bitmapHeight;
    }

    public int getPlanes() {
        return this.planes;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public long getCompressionType() {
        return this.compressionType;
    }

    public long getImageSize() {
        return this.imageSize;
    }

    public long getXPixelsPerMeter() {
        return this.xPixelsPerMeter;
    }

    public long getYPixelsPerMeter() {
        return this.yPixelsPerMeter;
    }

    public long getColorIndexesUsed() {
        return this.colorIndexesUsed;
    }

    public long getColorsImportant() {
        return this.colorsImportant;
    }

    public void read(RandomAccessFile raf) {
        try {
            this.thisSize = CDataReader.readDoubleWord(raf);
            this.bitmapWidth = CDataReader.readDoubleWord(raf);
            this.bitmapHeight = CDataReader.readDoubleWord(raf);
            this.planes = CDataReader.readWord(raf);
            this.bitsPerPixel = CDataReader.readWord(raf);
            this.compressionType = CDataReader.readDoubleWord(raf);
            this.imageSize = CDataReader.readDoubleWord(raf);
            this.xPixelsPerMeter = CDataReader.readDoubleWord(raf);
            this.yPixelsPerMeter = CDataReader.readDoubleWord(raf);
            this.colorIndexesUsed = CDataReader.readDoubleWord(raf);
            this.colorsImportant = CDataReader.readDoubleWord(raf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        Object s = "";
        s = "BitmapInfoHeader Size:\t" + this.thisSize + "\nBitmap Width:\t\t" + this.bitmapWidth + "\nBitmap Height:\t\t" + this.bitmapHeight + "\nPlanes:\t\t\t" + this.planes + "\nBits Per Pixel:\t\t" + this.bitsPerPixel + "\nCompression:\t\t" + this.compressionType + "\nImage Size:\t\t" + this.imageSize + "\nX Pixels Per Meter:\t" + this.xPixelsPerMeter + "\nY Pixels Per Meter:\t" + this.yPixelsPerMeter + "\nColor Indexes Used:\t" + this.colorIndexesUsed + "\nColors Important:\t" + this.colorsImportant;
        return s;
    }
}

