/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.graphics;

import com.jmorgan.image.ImageUtilities;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class JPEGWriter {
    public static final float HIGH_QUALITY = 1.0f;
    public static final float MEDIUM_QUALITY = 0.75f;
    public static final float LOW_QUALITY = 0.5f;
    private int xDPI;
    private int yDPI;
    private float quality;
    private BufferedImage image;
    private OutputStream outputStream;

    public JPEGWriter() {
        this.quality = 1.0f;
        this.xDPI = 300;
        this.yDPI = 300;
    }

    public JPEGWriter(int xDPI, int yDPI, float quality) {
        this.setDPI(xDPI, yDPI);
        this.setQuality(quality);
    }

    public JPEGWriter(Image image, OutputStream outputStream, int xDPI, int yDPI, float quality) {
        this(xDPI, yDPI, quality);
        this.setImage(image);
        this.setOutputStream(outputStream);
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public Image getImage() {
        return this.image;
    }

    public float getQuality() {
        return this.quality;
    }

    public int getXDPI() {
        return this.xDPI;
    }

    public int getYDPI() {
        return this.yDPI;
    }

    public void setOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("The outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("image is not allowed to be null.");
        }
        this.image = ImageUtilities.getBufferedImage(image);
    }

    public void setQuality(float quality) {
        if (quality < 0.0f || quality > 1.0f) {
            throw new IllegalArgumentException("The value of " + quality + " for quality must be between 0.0F and 1.0F");
        }
        this.quality = quality;
    }

    public void setDPI(int xDPI, int yDPI) {
        this.setXDPI(xDPI);
        this.setYDPI(yDPI);
    }

    public void setXDPI(int xDPI) {
        if (xDPI < 1) {
            throw new IllegalArgumentException("The value " + xDPI + " for xDPI must be greater than zero.");
        }
        this.xDPI = xDPI;
    }

    public void setYDPI(int yDPI) {
        if (yDPI < 1) {
            throw new IllegalArgumentException("The value " + yDPI + " for yDPI must be greater than zero.");
        }
        this.yDPI = yDPI;
    }

    public void writeJPEG() throws IOException {
        if (this.image == null) {
            throw new IllegalStateException("No image is set.  Cannot write JPEG without an image.");
        }
        if (this.outputStream == null) {
            throw new IllegalStateException("No outputStream is set.  Cannot write JPEG without an outputStream.");
        }
        ImageIO.write((RenderedImage)this.image, "JPEG", this.outputStream);
        this.outputStream.flush();
    }

    public void writeJPEG(Image image) throws IOException {
        this.setImage(image);
        this.writeJPEG();
    }

    public void writeJPEG(Image image, OutputStream outputStream) throws IOException {
        this.setImage(image);
        this.setOutputStream(outputStream);
        this.writeJPEG();
    }

    public void writeJPEG(Image image, File file) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        this.writeJPEG(image, fout);
        fout.close();
    }

    public void writeJPEG(Image image, String fileName) throws IOException {
        File file = new File(fileName);
        this.writeJPEG(image, file);
    }
}

