/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.graphics.drawing;

import com.jmorgan.graphics.drawing.AbstractDrawer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

public class FolderDrawer
extends AbstractDrawer {
    private Color insideColor;
    private Color outsideColor;

    public FolderDrawer(Point location, Dimension size) {
        this(location, size, new Color(255, 255, 0), new Color(128, 128, 0));
    }

    public FolderDrawer(Point location, Dimension size, Color insideColor, Color outsideColor) {
        super(location, size);
        this.setInsideColor(insideColor);
        this.setOutsideColor(outsideColor);
    }

    public Color getInsideColor() {
        return this.insideColor;
    }

    public void setInsideColor(Color insideColor) {
        this.insideColor = insideColor;
    }

    public Color getOutsideColor() {
        return this.outsideColor;
    }

    public void setOutsideColor(Color outsideColor) {
        this.outsideColor = outsideColor;
    }

    @Override
    public void draw(Graphics graphics) {
        super.draw(graphics);
        Dimension size = this.getSize();
        int oneEight = size.height / 8;
        int oneTenth = size.width / 10;
        Polygon inside = FolderDrawer.getInside(oneEight, oneTenth);
        Polygon outside = FolderDrawer.getOutside(oneEight, oneTenth);
        graphics.setColor(this.getInsideColor());
        graphics.fillPolygon(inside);
        graphics.drawPolygon(inside);
        graphics.setColor(this.getOutsideColor());
        graphics.fillPolygon(outside);
        graphics.drawPolygon(outside);
    }

    private static Polygon getInside(int oneEight, int oneTenth) {
        int[] nArray = new int[8];
        nArray[1] = oneTenth;
        nArray[2] = oneTenth * 3;
        nArray[3] = oneTenth * 4;
        nArray[4] = oneTenth * 8;
        nArray[5] = oneTenth * 8;
        nArray[6] = oneTenth * 4;
        int[] xPoints = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = oneEight;
        nArray2[3] = oneEight;
        nArray2[4] = oneEight;
        nArray2[5] = oneEight * 3;
        nArray2[6] = oneEight * 3;
        nArray2[7] = oneEight * 8;
        int[] yPoints = nArray2;
        Polygon inside = new Polygon(xPoints, yPoints, xPoints.length);
        return inside;
    }

    private static Polygon getOutside(int oneEight, int oneTenth) {
        int[] nArray = new int[4];
        nArray[0] = oneTenth * 4;
        nArray[1] = oneTenth * 10;
        nArray[2] = oneTenth * 8;
        int[] xPoints = nArray;
        int[] yPoints = new int[]{oneEight * 3, oneEight * 3, oneEight * 8, oneEight * 8};
        Polygon outside = new Polygon(xPoints, yPoints, xPoints.length);
        return outside;
    }
}

