/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;

public class ASCFileWriter {
    public ASCFileWriter(String fileName, String data) throws IOException {
        this(new File(fileName), data);
    }

    public ASCFileWriter(String fileName, String data, boolean append) throws IOException {
        this(new File(fileName), data, append);
    }

    public ASCFileWriter(File file, String data) throws IOException {
        ASCFileWriter.writeData(file, data);
    }

    public ASCFileWriter(File file, String data, boolean append) throws IOException {
        ASCFileWriter.writeData(file, data, append);
    }

    public ASCFileWriter(String fileName, Collection<String> data) throws IOException {
        this(new File(fileName), data);
    }

    public ASCFileWriter(String fileName, Collection<String> data, boolean append) throws IOException {
        this(new File(fileName), data, true);
    }

    public ASCFileWriter(File file, Collection<String> data) throws IOException {
        this(file, data, false);
    }

    public ASCFileWriter(File file, Collection<String> data, boolean append) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String line : data) {
            sb.append(line);
            sb.append('\n');
        }
        ASCFileWriter.writeData(file, sb.toString());
    }

    public static void writeData(File file, String data) throws IOException {
        ASCFileWriter.writeData(file, data, false);
    }

    private static void writeData(File file, String data, boolean append) throws IOException {
        int bufferSize;
        int dataLength = data.length();
        int n = bufferSize = dataLength > 65535 ? 65535 : dataLength;
        if (bufferSize <= 0) {
            bufferSize = 1024;
        }
        FileWriter fw = new FileWriter(file, append);
        BufferedWriter bw = new BufferedWriter(fw, bufferSize);
        bw.write(data);
        bw.flush();
        fw.flush();
        bw.close();
        fw.close();
    }
}

