/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileOutputStream;

public class BeanFileWriter<T> {
    private T object;
    private File file;

    public BeanFileWriter() {
    }

    public BeanFileWriter(File file, T object) {
        this.setFile(file);
        this.setObject(object);
        this.write();
    }

    public BeanFileWriter(String fileName, T object) {
        this(new File(fileName), object);
    }

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void write() throws IllegalStateException, RuntimeException {
        if (this.file == null || this.object == null) {
            throw new IllegalStateException("BeanFileWriter.write():  Either the file or the object has not been set");
        }
        try {
            FileOutputStream fw = new FileOutputStream(this.file);
            XMLEncoder encoder = new XMLEncoder(fw);
            encoder.writeObject(this.object);
            encoder.flush();
            encoder.close();
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            throw new RuntimeException("BeanFileWriter.write():\n" + String.valueOf(e));
        }
    }
}

