/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.io.IORowObject;
import com.jmorgan.util.collection.CollectionExecutor;
import java.util.Collection;

final class DEOExecutor
extends CollectionExecutor<IORowObject> {
    static final int EXECUTE_DELETE = 0;
    static final int EXECUTE_COMMIT = 1;
    static final int EXECUTE_ROLLBACK = 2;
    static final int EXECUTE_REMOVE = 3;
    private int executeType;

    DEOExecutor(Collection<IORowObject> collection, int executeType) throws NullPointerException {
        super(collection);
        this.setExecuteType(executeType);
    }

    @Override
    public void processElement(IORowObject row) {
        switch (this.executeType) {
            case 0: {
                row.setDeleted(true);
                break;
            }
            case 1: {
                row.commit();
                row.setNew(false);
                break;
            }
            case 2: {
                row.rollback();
                break;
            }
            case 3: {
                this.iterator.remove();
            }
        }
    }

    void setExecuteType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.executeType = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("DEOExecutor.setExecuteType(" + type + "):  Execute type is invalid");
            }
        }
    }
}

