/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.io.DEO;
import com.jmorgan.io.IORowObject;
import com.jmorgan.util.Pair;
import com.jmorgan.util.collection.CollectionSelector;
import java.util.ArrayList;
import java.util.Collection;

public final class DEORowSelector<E>
extends CollectionSelector<E> {
    public static final int DELETED_ITEMS = 0;
    public static final int NON_DELETED_ITEMS = 1;
    public static final int NEW_ITEMS = 2;
    public static final int CHANGED_ITEMS = 3;
    public static final int MATCHING_ITEMS = 4;
    private ArrayList<Pair<Integer, Object>> searchCriteria;
    private int selectionType;

    public DEORowSelector(DEO deo) {
        this(deo.getData());
    }

    public DEORowSelector(Collection<? extends E> collection) throws NullPointerException {
        super(collection);
    }

    @Override
    protected boolean isElementSelected(E element) {
        IORowObject row = (IORowObject)element;
        switch (this.selectionType) {
            case 0: {
                if (!row.isDeleted()) break;
                return true;
            }
            case 1: {
                if (row.isDeleted()) break;
                return true;
            }
            case 2: {
                if (!row.isNew() || row.isDeleted()) break;
                return true;
            }
            case 3: {
                if (row.isDeleted() || row.isNew() || !row.hasChanged()) break;
                return true;
            }
            case 4: {
                for (Pair<Integer, Object> criteria : this.searchCriteria) {
                    double v2;
                    double v1;
                    double difference;
                    Object colValue = row.getValue(criteria.getFirst());
                    Object matchValue = criteria.getSecond();
                    if (!(colValue instanceof Number && matchValue instanceof Number ? (difference = Math.abs((v1 = ((Number)colValue).doubleValue()) - (v2 = ((Number)matchValue).doubleValue()))) > 1.0E-15 : !colValue.equals(matchValue))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void setSelectionType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.selectionType = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Type is invalid");
            }
        }
    }

    public void addSearchCriteria(int columnNumber, Object value) {
        if (this.searchCriteria == null) {
            this.searchCriteria = new ArrayList();
        }
        Pair<Integer, Object> pair = new Pair<Integer, Object>(columnNumber, value);
        this.searchCriteria.add(pair);
        this.setSelectionType(4);
    }

    public void removeSearchCriteria(int columnNumber, Object value) {
        Pair<Integer, Object> criteria = new Pair<Integer, Object>(columnNumber, value);
        this.searchCriteria.remove(criteria);
        if (this.searchCriteria.size() == 0) {
            this.setSelectionType(1);
        }
    }

    public void clearSearchCriteria() {
        this.searchCriteria.clear();
        this.setSelectionType(1);
    }
}

