/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.io.DefaultIOColumnObject;
import com.jmorgan.io.IOColumnExecutor;
import com.jmorgan.io.IOColumnInfo;
import com.jmorgan.io.IOColumnObject;
import com.jmorgan.io.IORowColumnSelector;
import com.jmorgan.io.IORowObject;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;

public class DefaultIORowObject<CIT extends IOColumnInfo>
implements IORowObject {
    private boolean isNew = true;
    private boolean isDeleted = false;
    private ArrayList<IOColumnObject> columnData;
    private ArrayList<CIT> columnInfo;
    private transient IORowColumnSelector columnSelector;
    private transient IOColumnExecutor columnExecutor;
    private PropertyChangeSupport propertyChangeSupporter = new PropertyChangeSupport(this);

    public DefaultIORowObject(Collection<CIT> columnInfo) {
        this.columnInfo = new ArrayList<CIT>(columnInfo);
        this.columnData = new ArrayList();
        for (IOColumnInfo cinfo : columnInfo) {
            DefaultIOColumnObject colObject = (DefaultIOColumnObject)this.getColumnInstance();
            colObject.setColumnName(cinfo.getColumnName());
            this.columnData.add(colObject);
        }
        this.columnSelector = new IORowColumnSelector((Collection<IOColumnObject>)this.columnData);
        this.columnExecutor = new IOColumnExecutor((Collection<IOColumnObject>)this.columnData);
    }

    public DefaultIORowObject(Collection<CIT> columnInfo, Collection<IOColumnObject> columns) {
        this(columnInfo);
        this.isNew = false;
        this.columnData.clear();
        this.columnData.addAll(columns);
    }

    public ArrayList<CIT> getColumnInfo() {
        return this.columnInfo;
    }

    protected IOColumnObject getColumnInstance() {
        return new DefaultIOColumnObject(this, "");
    }

    @Override
    public int getColumnCount() {
        return this.columnData.size();
    }

    @Override
    public Collection<IOColumnObject> getColumns() {
        return this.columnData;
    }

    @Override
    public IOColumnObject getColumn(int column) throws ArrayIndexOutOfBoundsException {
        this.validateColumnNumber(column);
        return this.columnData.get(column);
    }

    @Override
    public IOColumnObject getColumn(String columnName) {
        for (IOColumnObject colObject : this.columnData) {
            if (!colObject.getColumnName().equals(columnName)) continue;
            return colObject;
        }
        return null;
    }

    @Override
    public String getColumnName(int columnNo) {
        return ((IOColumnInfo)this.columnInfo.get(columnNo)).getColumnName();
    }

    @Override
    public Object getValue(int column) throws ArrayIndexOutOfBoundsException {
        return this.getColumn(column).getValue();
    }

    @Override
    public void setValue(int column, Object value) throws ArrayIndexOutOfBoundsException {
        this.getColumn(column).setValue(value);
    }

    private void validateColumnNumber(int column) throws ArrayIndexOutOfBoundsException {
        int columnCount = this.columnData.size();
        if (column < 0 || column >= columnCount) {
            throw new ArrayIndexOutOfBoundsException("The column " + column + " is invalid.  It should be in the range 0 to " + (columnCount - 1));
        }
    }

    @Override
    public boolean hasChanged() {
        this.columnSelector.setSelectionType(0);
        return this.columnSelector.getSelectedElements().size() > 0;
    }

    @Override
    public void commit() {
        this.columnExecutor.setExecuteType(0);
        this.columnExecutor.execute();
    }

    @Override
    public void rollback() {
        this.columnExecutor.setExecuteType(1);
        this.columnExecutor.execute();
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void setNew(boolean state) {
        if (this.isNew != state) {
            if (this.propertyChangeSupporter.hasListeners()) {
                Boolean oldValue = new Boolean(this.isNew);
                Boolean newValue = new Boolean(state);
                this.isNew = state;
                this.propertyChangeSupporter.firePropertyChange("isNew", oldValue, newValue);
            } else {
                this.isNew = state;
            }
        }
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public void setDeleted(boolean state) {
        if (this.isDeleted != state) {
            if (this.propertyChangeSupporter.hasListeners()) {
                Boolean oldValue = new Boolean(this.isDeleted);
                Boolean newValue = new Boolean(state);
                this.isDeleted = state;
                this.propertyChangeSupporter.firePropertyChange("isDeleted", oldValue, newValue);
            } else {
                this.isDeleted = state;
            }
        }
    }

    @Override
    public void reset() {
        if (this.columnData == null) {
            return;
        }
        for (IOColumnObject column : this.getColumns()) {
            column.reset();
        }
        this.columnData.clear();
        this.columnData = null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupporter.addPropertyChangeListener(listener);
        for (IOColumnObject column : this.getColumns()) {
            column.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupporter.removePropertyChangeListener(listener);
        Collection<IOColumnObject> columnData = this.getColumns();
        if (columnData == null) {
            return;
        }
        for (IOColumnObject column : columnData) {
            if (column == null) continue;
            column.removePropertyChangeListener(listener);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.columnSelector = new IORowColumnSelector((Collection<IOColumnObject>)this.columnData);
        this.columnExecutor = new IOColumnExecutor((Collection<IOColumnObject>)this.columnData);
    }

    @Override
    public int compareTo(IORowObject that) {
        if (this.equals(that)) {
            return 0;
        }
        int thisColumnCount = this.getColumnCount();
        int thatColumnCount = that.getColumnCount();
        int minimumColumnCount = Math.min(thisColumnCount, thatColumnCount);
        int i = 0;
        while (i < minimumColumnCount) {
            IOColumnObject thatColumn;
            IOColumnObject thisColumn = this.getColumn(i);
            int columnCmp = thisColumn.compareTo(thatColumn = that.getColumn(i));
            if (columnCmp != 0) {
                return columnCmp;
            }
            ++i;
        }
        return thisColumnCount - thatColumnCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IORowObject) {
            int thatColumnCount;
            IORowObject that = (IORowObject)o;
            int thisColumnCount = this.getColumnCount();
            if (thisColumnCount != (thatColumnCount = that.getColumnCount())) {
                return false;
            }
            int i = 0;
            while (i < thisColumnCount) {
                IOColumnObject thatColumn;
                IOColumnObject thisColumn = this.getColumn(i);
                if (!thisColumn.equals(thatColumn = that.getColumn(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

