/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.io.File;
import com.jmorgan.io.InputStreamHelper;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStreamHelper
extends InputStreamHelper {
    private java.io.File file;
    private String fileName;

    public FileInputStreamHelper(String fileName) {
        this.setFileName(fileName);
    }

    public FileInputStreamHelper(java.io.File file) {
        this.setFile(file);
    }

    public FileInputStreamHelper(String fileName, int bufferSize) {
        super(bufferSize);
        this.setFileName(fileName);
    }

    public FileInputStreamHelper(java.io.File file, int bufferSize) {
        super(bufferSize);
        this.setFile(file);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.file = new File(this.fileName);
    }

    public java.io.File getFile() {
        return this.file;
    }

    public void setFile(java.io.File file) {
        this.file = file;
        this.fileName = file.getAbsolutePath();
    }

    @Override
    public InputStream open() {
        if (this.bufferSize == 0) {
            this.bufferSize = 16384;
        }
        try {
            FileInputStream fin = new FileInputStream(this.file);
            this.stackStream(fin);
            this.stackStream(new BufferedInputStream(fin, this.bufferSize));
            this.isOpen = true;
        }
        catch (IOException ioEx) {
            this.exception = ioEx;
            return null;
        }
        return (InputStream)this.getStream();
    }
}

