/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.io.OutputStreamHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputStreamHelper
extends OutputStreamHelper {
    private File file;
    private String fileName;

    public FileOutputStreamHelper(String fileName) {
        this.setFileName(fileName);
    }

    public FileOutputStreamHelper(File file) {
        this.setFile(file);
    }

    public FileOutputStreamHelper(String fileName, int bufferSize) {
        super(bufferSize);
        this.setFileName(fileName);
    }

    public FileOutputStreamHelper(File file, int bufferSize) {
        super(bufferSize);
        this.setFile(file);
    }

    public File getFile() {
        return this.file;
    }

    private void setFile(File file) {
        this.file = file;
        this.fileName = file.getAbsolutePath();
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
        this.setFile(new File(this.fileName));
    }

    @Override
    public OutputStream open() {
        if (this.bufferSize == 0) {
            this.bufferSize = 16384;
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.file);
            this.stackStream(fout);
            this.stackStream(new BufferedOutputStream(fout, this.bufferSize));
        }
        catch (IOException ioEx) {
            this.exception = ioEx;
            ioEx.printStackTrace();
            return null;
        }
        return (OutputStream)this.getStream();
    }
}

