/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.io.File;
import com.jmorgan.io.WriterHelper;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class FileWriterHelper
extends WriterHelper {
    private FileWriter fileWriter;
    private java.io.File file;
    private String fileName;

    public FileWriterHelper(String fileName) {
        this.setFileName(fileName);
    }

    public FileWriterHelper(java.io.File file) {
        this.setFile(file);
    }

    public FileWriterHelper(String fileName, int bufferSize) {
        super(bufferSize);
        this.setFileName(fileName);
    }

    public FileWriterHelper(java.io.File file, int bufferSize) {
        super(bufferSize);
        this.setFile(file);
    }

    protected void setFileWriter(FileWriter fileWriter) {
        this.fileWriter = fileWriter;
    }

    protected java.io.File getFile() {
        return this.file;
    }

    private void setFile(java.io.File file) {
        this.file = file;
        this.fileName = file.getAbsolutePath();
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
        this.file = new File(this.fileName);
    }

    @Override
    public Writer open() {
        if (this.bufferSize == 0) {
            this.bufferSize = 16384;
        }
        try {
            this.fileWriter = new FileWriter(this.file);
            this.bufferedWriter = new BufferedWriter(this.fileWriter, this.bufferSize);
        }
        catch (IOException ioEx) {
            this.exception = ioEx;
        }
        this.setWriter(this.bufferedWriter);
        return this.bufferedWriter;
    }
}

