/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.beans.ReadFileBean;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PagedFileReader {
    private File file;
    private int getPageNo;
    private int pageSize;
    private String contentFilter;

    public PagedFileReader(String fileName) {
        this(fileName, null, 0, 0);
    }

    public PagedFileReader(String fileName, String contentFilter) {
        this(fileName, contentFilter, 0, 0);
    }

    public PagedFileReader(String fileName, int pageNo, int pageSize) {
        this(fileName, null, pageNo, pageSize);
    }

    public PagedFileReader(String fileName, String contentFilter, int pageNo, int pageSize) {
        this.setFile(fileName);
        this.setContentFilter(contentFilter);
        this.setGetPageNo(pageNo);
        this.setPageSize(pageSize);
    }

    public PagedFileReader(ReadFileBean readInfo) {
        this(readInfo.getFileName(), readInfo.getContentFilter(), readInfo.getPageNo(), readInfo.getPageSize());
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(String fileName) {
        this.setFile(new File(fileName));
    }

    public void setFile(File file) {
        this.file = file;
    }

    public int getGetPageNo() {
        return this.getPageNo;
    }

    public void setGetPageNo(int getPageNo) {
        this.getPageNo = getPageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getContentFilter() {
        return this.contentFilter;
    }

    public void setContentFilter(String contentFilter) {
        this.contentFilter = contentFilter;
    }

    public ArrayList<String> getLines() {
        if (this.contentFilter == null || this.contentFilter.trim().length() == 0) {
            this.contentFilter = ".*";
        }
        Pattern pattern = Pattern.compile(this.contentFilter);
        ArrayList<String> lines = new ArrayList<String>();
        if (this.getPageNo != 0 || this.pageSize != 0) {
            if (this.getPageNo == 0) {
                this.getPageNo = 1;
            }
            if (this.pageSize == 0) {
                this.pageSize = 1000;
            }
        }
        try {
            FileReader fr = new FileReader(this.file);
            LineNumberReader lr = new LineNumberReader(fr, 32768);
            String line = null;
            int pageNo = 1;
            int lineNo = 0;
            while ((line = lr.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                if (++lineNo > this.pageSize) {
                    lineNo = 1;
                    ++pageNo;
                }
                if (this.getPageNo != 0 && pageNo > this.getPageNo) break;
                if (this.getPageNo != 0 && pageNo != this.getPageNo) continue;
                lines.add(line);
            }
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines;
    }
}

