/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import java.util.Arrays;

public class RetrievalArgument
extends JMBean
implements Comparable<RetrievalArgument> {
    private String columnName;
    private String operator;
    private Object value;
    private String logicalOperator;

    public RetrievalArgument(String columnName, Object value) {
        this(columnName, "=", value, "and");
    }

    public RetrievalArgument(String columnName, Object value, String logicalOperator) {
        this(columnName, "=", value, logicalOperator);
    }

    public RetrievalArgument(String columnName, String operator, Object value) {
        this(columnName, operator, value, "and");
    }

    public RetrievalArgument(String columnName, String operator, Object value, String logicalOperator) {
        this.setColumnName(columnName);
        this.setValue(value);
        this.setOperator(operator);
        this.setLogicalOperator(logicalOperator);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Object getValue() {
        return this.value;
    }

    public String getLogicalOperator() {
        return this.logicalOperator;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setValue(Object value) {
        String sValue;
        if (value instanceof String && (sValue = ((String)value).trim()).length() > 0 && (sValue.startsWith("'") || sValue.startsWith("\"")) && (sValue.endsWith("'") || sValue.endsWith("\""))) {
            sValue = sValue.substring(1, sValue.length() - 1);
            this.value = sValue;
            return;
        }
        this.value = value;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String string) {
        this.operator = string;
    }

    public void setLogicalOperator(String logicalOperator) {
        this.logicalOperator = " " + logicalOperator + " ";
    }

    @Override
    public int compareTo(RetrievalArgument that) {
        if (that == null) {
            return 1;
        }
        if (this.equals(that)) {
            return 0;
        }
        return this.compare((Comparable)((Object)this.columnName), (Comparable)((Object)that.columnName));
    }

    @Override
    public int hashCode() {
        return BeanService.getHashCode(this);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof RetrievalArgument) {
            RetrievalArgument that = (RetrievalArgument)o;
            return this.columnName.equalsIgnoreCase(that.columnName) && this.operator.equalsIgnoreCase(that.operator) && this.value.equals(that.value) && this.logicalOperator.equalsIgnoreCase(that.logicalOperator);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.columnName + " " + this.operator + " ");
        if (this.value instanceof Object[]) {
            sb.append(Arrays.toString((Object[])this.value));
        } else {
            sb.append(this.value);
        }
        sb.append(" " + this.logicalOperator.trim());
        return sb.toString();
    }
}

