/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.io.SystemPrintStreamListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Locale;

public class SystemPrintStreamInterceptor
extends PrintStream {
    private ArrayList<SystemPrintStreamListener> listeners;
    private PrintStream originalStream;
    private boolean forward;

    public SystemPrintStreamInterceptor(PrintStream streamToIntercept, boolean forward) {
        super(new OutputStream(){

            @Override
            public void write(int b) {
            }
        });
        if (streamToIntercept == System.out) {
            this.originalStream = System.out;
            System.setOut(this);
        } else {
            this.originalStream = System.err;
            System.setErr(this);
        }
        this.forward = forward;
    }

    @Override
    public void print(boolean b) {
        this.sendEvent("" + b);
        if (this.forward) {
            this.originalStream.print(b);
        }
    }

    @Override
    public void print(char c) {
        this.sendEvent("" + c);
        if (this.forward) {
            this.originalStream.print(c);
        }
    }

    @Override
    public void print(char[] s) {
        this.sendEvent(new String(s));
        if (this.forward) {
            this.originalStream.print(s);
        }
    }

    @Override
    public void print(double d) {
        this.sendEvent("" + d);
        if (this.forward) {
            this.originalStream.print(d);
        }
    }

    @Override
    public void print(float f) {
        this.sendEvent("" + f);
        if (this.forward) {
            this.originalStream.print(f);
        }
    }

    @Override
    public void print(int i) {
        this.sendEvent("" + i);
        if (this.forward) {
            this.originalStream.print(i);
        }
    }

    @Override
    public void print(long l) {
        this.sendEvent("" + l);
        if (this.forward) {
            this.originalStream.print(l);
        }
    }

    @Override
    public void print(Object obj) {
        this.sendEvent(obj.toString());
        if (this.forward) {
            this.originalStream.print(obj);
        }
    }

    @Override
    public void print(String s) {
        this.sendEvent(s);
        if (this.forward) {
            this.originalStream.print(s);
        }
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream newOut = new PrintStream(bout);
        newOut.printf(l, format, args);
        newOut.flush();
        newOut.close();
        String output = bout.toString();
        this.sendEvent(output);
        if (this.forward) {
            this.originalStream.printf(l, format, args);
        }
        return this;
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream newOut = new PrintStream(bout);
        newOut.printf(format, args);
        newOut.flush();
        newOut.close();
        String output = bout.toString();
        this.sendEvent(output);
        if (this.forward) {
            this.originalStream.printf(format, args);
        }
        return this;
    }

    @Override
    public void println() {
        this.sendEvent("\n");
        if (this.forward) {
            this.originalStream.println();
        }
    }

    @Override
    public void println(boolean x) {
        this.sendEvent(x + "\n");
        if (this.forward) {
            this.originalStream.println(x);
        }
    }

    @Override
    public void println(char x) {
        this.sendEvent(x + "\n");
        if (this.forward) {
            this.originalStream.println(x);
        }
    }

    @Override
    public void println(char[] x) {
        this.sendEvent(new String(x) + "\n");
        if (this.forward) {
            this.originalStream.println(x);
        }
    }

    @Override
    public void println(double x) {
        this.sendEvent(x + "\n");
        if (this.forward) {
            this.originalStream.println(x);
        }
    }

    @Override
    public void println(float x) {
        this.sendEvent(x + "\n");
        if (this.forward) {
            this.originalStream.println(x);
        }
    }

    @Override
    public void println(int x) {
        this.sendEvent(x + "\n");
        if (this.forward) {
            this.originalStream.println(x);
        }
    }

    @Override
    public void println(long x) {
        this.sendEvent(x + "\n");
        if (this.forward) {
            this.originalStream.println(x);
        }
    }

    @Override
    public void println(Object x) {
        this.sendEvent(x.toString() + "\n");
        if (this.forward) {
            this.originalStream.println(x);
        }
    }

    @Override
    public void println(String x) {
        this.sendEvent(x + "\n");
        if (this.forward) {
            this.originalStream.println(x);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.sendEvent(new String(buf, off, len) + "\n");
        if (this.forward) {
            this.originalStream.write(buf, off, len);
        }
    }

    @Override
    public void write(int b) {
        this.sendEvent(b + "\n");
        if (this.forward) {
            this.originalStream.write(b);
        }
    }

    public void addPrintStreamListener(SystemPrintStreamListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removePrintStreamListener(SystemPrintStreamListener listener) {
        if (listener == null || this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void sendEvent(String message) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        for (SystemPrintStreamListener listener : this.listeners) {
            listener.messageIntercepted(this.originalStream, message);
        }
    }
}

