/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public abstract class WriterHelper {
    private Writer writer;
    protected int bufferSize;
    protected BufferedWriter bufferedWriter;
    protected IOException exception;

    public WriterHelper() {
    }

    public WriterHelper(int bufferSize) {
        this();
        this.bufferSize = bufferSize;
    }

    public Writer getWriter() {
        return this.writer;
    }

    protected void setWriter(Writer writer) {
        this.writer = writer;
    }

    protected IOException getException() {
        return this.exception;
    }

    public abstract Writer open();

    public boolean flush() {
        this.exception = null;
        try {
            if (this.bufferedWriter != null) {
                this.bufferedWriter.flush();
            }
            this.writer.flush();
        }
        catch (IOException e) {
            this.exception = e;
            return false;
        }
        return true;
    }

    public boolean close() {
        this.exception = null;
        this.flush();
        try {
            if (this.bufferedWriter != null) {
                this.bufferedWriter.close();
            }
            this.writer.close();
        }
        catch (IOException e) {
            this.exception = e;
            return false;
        }
        return true;
    }
}

