/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io.excel;

import com.jmorgan.beans.util.DataTypeConverter;
import com.jmorgan.io.IORowObject;
import com.jmorgan.io.IORowObjectBeanMap;
import com.jmorgan.io.excel.ColumnPropertyMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ColumnPropertyBeanMap<T>
extends IORowObjectBeanMap<T> {
    private Collection<ColumnPropertyMap<?, ?>> columnPropertyMap;

    public ColumnPropertyBeanMap(Collection<ColumnPropertyMap<?, ?>> columnPropertyMap, IORowObject row, T bean) {
        this.setBean(bean);
        this.setIORowObject(row);
        this.setColumnPropertyMap(columnPropertyMap);
        this.loadBean();
    }

    public void setColumnPropertyMap(Collection<ColumnPropertyMap<?, ?>> columnPropertyMap) {
        this.columnPropertyMap = columnPropertyMap;
    }

    @Override
    public Map<String, Object> getMap() {
        Map<String, Object> map = super.getMap();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        block0: for (String columnName : map.keySet()) {
            for (ColumnPropertyMap<?, ?> cpm : this.columnPropertyMap) {
                if (!cpm.getColumnName().equals(columnName)) continue;
                newMap.put(cpm.getPropertyName(), map.get(columnName));
                continue block0;
            }
        }
        return newMap;
    }

    @Override
    public Object getValueFor(String property, Object value) {
        for (ColumnPropertyMap<?, ?> cpm : this.columnPropertyMap) {
            if (!cpm.getPropertyName().equals(property)) continue;
            DataTypeConverter<?, ?> converter = cpm.getDataTypeConverter();
            if (converter == null) {
                return value;
            }
            return converter.convert(value);
        }
        return value;
    }
}

