/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.ApplicationProperties;
import com.jmorgan.lang.GUIApplicationProperties;
import com.jmorgan.lang.UIApplicationProperties;
import com.jmorgan.swing.JMFrame;
import com.jmorgan.util.Pair;
import com.jmorgan.util.logging.LMG;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public abstract class GUIApplication
extends Application {
    public static final String APPLICATION_FRAME = "GUIApplication.applicationFrame";
    public static final String ART_ROOT = "GUIApplication.artRoot";
    private static GUIApplication guiApplication;

    public static GUIApplication getGUIApplication() {
        return guiApplication;
    }

    public static URL getMenuResource(String appArtRootDirectory, String imageName) {
        String fqfn = String.format("%s%s", appArtRootDirectory, imageName);
        URL resource = GUIApplication.class.getResource(fqfn);
        if (resource == null) {
            LMG.log(Level.SEVERE, String.format("URL resource cannot be created for %s", fqfn));
        }
        return resource;
    }

    public static Image getImageResource(String appArtRootDirectory, String imageName) {
        String fqfn = String.format("%s%s", appArtRootDirectory, imageName);
        guiApplication.getApplicationLogger().finer(String.format("appArtRootDirectory=%s, imageName=%s, fqfn=%s", appArtRootDirectory, imageName, fqfn));
        BufferedImage imageResource = null;
        try {
            imageResource = ImageIO.read(GUIApplication.class.getResource(fqfn));
        }
        catch (IOException e) {
            guiApplication.getApplicationLogger().severe(String.format("Image resource cannot be created for %s", fqfn));
            e.printStackTrace();
        }
        return imageResource;
    }

    protected GUIApplication(String[] args) {
        super(args);
        guiApplication = this;
        this.setupDefaultUI();
        this.setAttribute(ART_ROOT, this.getArtRoot());
        try {
            Class.forName("com.jmorgan.swing.menu.MenuConstants");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        JMFrame frame = this.createApplicationFrame();
        this.setAttribute(APPLICATION_FRAME, frame);
    }

    protected void setupDefaultUI() {
        Font defaultFont = this.getDefaultFont();
        this.setFontForComponentTypes(defaultFont);
        Border textFieldBorder = UIManager.getBorder("TextField.border");
        CompoundBorder newBorder = BorderFactory.createCompoundBorder(textFieldBorder, BorderFactory.createEmptyBorder(0, 5, 0, 5));
        UIManager.put("TextField.border", newBorder);
        UIManager.put("PasswordField.border", newBorder);
        Insets tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        Insets newInsets = new Insets(5, tabInsets.left, 5, tabInsets.right);
        UIManager.put("TabbedPane.tabInsets", newInsets);
    }

    public void setFontForComponentTypes(Font font) {
        String[] fontElements = new String[]{"Button.font", "CheckBox.font", "CheckBoxMenuItem.font", "ColorChooser.font", "ComboBox.font", "DesktopIcon.font", "EditorPane.font", "FormattedTextField.font", "Label.font", "List.font", "Menu.font", "MenuBar.font", "MenuItem.font", "OptionPane.font", "Panel.font", "PasswordField.font", "PopMenu.font", "ProgressBar.font", "RadioButton.font", "RadioButtonMenuItem.font", "ScrollPane.font", "Slider.font", "Spinner.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextArea.font", "TextField.font", "TextPane.font", "TitledBorder.font", "ToggleButton.font", "ToolBar.font", "ToolTip.font", "Tree.font", "Viewport.font"};
        FontUIResource fontUIResource = new FontUIResource(font);
        String[] stringArray = fontElements;
        int n = fontElements.length;
        int n2 = 0;
        while (n2 < n) {
            String fontElement = stringArray[n2];
            UIManager.put(fontElement, fontUIResource);
            ++n2;
        }
    }

    protected Font getDefaultFont() {
        return new Font("Tahoma", 0, 12);
    }

    public JMFrame createApplicationFrame() {
        Pair<String, String> packageAndClass = this.getPackageAndClass();
        String frameClassName = (String)packageAndClass.first + ".ui." + (String)packageAndClass.second + "Frame";
        JMFrame frame = null;
        try {
            frame = (JMFrame)BeanService.getBean(frameClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return frame;
    }

    public JMFrame getApplicationFrame() {
        return (JMFrame)this.getAttribute(APPLICATION_FRAME);
    }

    public void setApplicationFrame(JMFrame applicationFrame) {
        this.setAttribute(APPLICATION_FRAME, applicationFrame);
    }

    public String getArtRoot() {
        GUIApplicationProperties appProperties = (GUIApplicationProperties)((Object)this.getApplicationProperties());
        String artRoot = String.format("%s/", appProperties.getArtRoot().getName());
        this.getApplicationLogger().finer(String.format("GUIApplication.getArtRoot(): Art Root=%s", artRoot));
        return artRoot;
    }

    @Override
    public ApplicationProperties createApplicationPropertiesObject() {
        ApplicationProperties applicationProperties = this.createApplicationPropertiesObject(false);
        if (applicationProperties != null) {
            return applicationProperties;
        }
        return new UIApplicationProperties();
    }

    public String getLegalLicense() {
        ApplicationProperties appProperties = (ApplicationProperties)this.getAttributes().get("Application.properties");
        String legalLicenseDirectory = appProperties.getLegalLicenseDirectory();
        try {
            InputStream in = this.getClass().getResourceAsStream(legalLicenseDirectory);
            BufferedInputStream bin = new BufferedInputStream(in, 16384);
            StringBuilder sb = new StringBuilder();
            int ch = bin.read();
            while (ch != -1) {
                sb.append((char)ch);
                ch = bin.read();
            }
            bin.close();
            in.close();
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Error Reading Legal License at " + legalLicenseDirectory;
        }
    }

    public static void setMetalLookAndFeel() {
        MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        GUIApplication.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel", "Metal Look & Feel");
    }

    public static void setWindowsLookAndFeel() {
        GUIApplication.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel", "Windows Look and Feel");
    }

    public static void setMotifLookAndFeel() {
        GUIApplication.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel", "Motif Look and Feel");
    }

    public static void setJavaLookAndFeel() {
        GUIApplication.setMetalLookAndFeel();
    }

    private static void setLookAndFeel(String className, String humanName) {
        try {
            UIManager.setLookAndFeel(className);
            JMFrame frame = guiApplication.getApplicationFrame();
            if (frame != null) {
                SwingUtilities.updateComponentTreeUI(frame);
            }
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println(humanName + " not supported on this platform. \nProgram Terminated");
            System.exit(0);
        }
        catch (IllegalAccessException e) {
            System.err.println(humanName + " could not be accessed. \nProgram Terminated");
            System.exit(0);
        }
        catch (ClassNotFoundException e) {
            System.err.println(humanName + " could not be found. \nProgram Terminated");
            System.exit(0);
        }
        catch (InstantiationException e) {
            System.err.println(humanName + " could not be instantiated. \nProgram Terminated");
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Unexpected error. \nProgram Terminated");
            e.printStackTrace();
            System.exit(0);
        }
    }
}

