/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

import com.jmorgan.lang.InvocationEvent;
import com.jmorgan.lang.InvocationListener;
import com.jmorgan.util.ThreadUtility;

public class SingleThreadInvocationListener
implements InvocationListener {
    private boolean complete;

    public boolean invocationComplete() {
        return this.complete;
    }

    public void waitForCompletion() {
        this.waitForCompletion(Integer.MAX_VALUE);
    }

    public boolean waitForCompletion(int timeout) {
        long stopTime = System.currentTimeMillis() + (long)timeout;
        while (!this.complete && System.currentTimeMillis() < stopTime) {
            ThreadUtility.sleep(50L);
        }
        return System.currentTimeMillis() < stopTime;
    }

    public void clearCompletionStatus() {
        this.complete = false;
    }

    @Override
    public boolean methodInvocationNotice(InvocationEvent invocationEvent) {
        this.complete = false;
        return true;
    }

    @Override
    public void methodInvoked(InvocationEvent invocationEvent) {
        this.complete = true;
    }

    @Override
    public void methodInvocationCancelled(InvocationEvent invocationEvent) {
        this.complete = true;
    }
}

