/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

public class StackTrace {
    private Throwable throwable;

    public StackTrace() {
    }

    public StackTrace(Throwable throwable) {
        this.throwable = throwable;
        System.err.println(StackTrace.getStackTrace(throwable));
    }

    public static String getStackTrace(Throwable throwable) {
        Throwable cause;
        if (throwable == null) {
            throw new IllegalArgumentException("The throwable for StackTrace.getStackTrace() is not allowed to be null.");
        }
        StringBuilder sb = new StringBuilder();
        String message = throwable.getMessage();
        sb.append(throwable.getClass().getName());
        if (message != null) {
            sb.append(": ");
            sb.append(message);
        }
        boolean isStackOverflowError = throwable instanceof StackOverflowError;
        StackTraceElement[] stackElements = throwable.getStackTrace();
        int currentElement = 0;
        int repeatsAtElement = 0;
        StackTraceElement[] stackTraceElementArray = stackElements;
        int n = stackElements.length;
        int n2 = 0;
        block0: while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            if (isStackOverflowError && currentElement > 0) {
                int i = 0;
                while (i < currentElement) {
                    if (element.equals(stackElements[i])) {
                        repeatsAtElement = i;
                        break block0;
                    }
                    ++i;
                }
            }
            sb.append("\n\t");
            sb.append(element.toString());
            ++currentElement;
            ++n2;
        }
        sb.append("\n");
        if (isStackOverflowError) {
            sb.append("Full overflow stack trace truncated.  Overflow repeats from\n\t");
            sb.append(stackElements[repeatsAtElement]);
        }
        if ((cause = throwable.getCause()) != null && cause != throwable) {
            sb.append("Caused By ");
            sb.append(StackTrace.getStackTrace(cause));
        }
        return sb.toString();
    }

    public String toString() {
        return StackTrace.getStackTrace(this.throwable);
    }
}

