/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.net;

import com.jmorgan.io.FileInputStreamHelper;
import com.jmorgan.net.InvalidPCAPFormat;
import com.jmorgan.net.PCAPHeader;
import com.jmorgan.net.PCAPPacket;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class PCAPReader {
    private DataInputStream dataInputStream;
    private PCAPHeader pcapHeader;

    public PCAPReader(InputStream inputStream) {
        this.dataInputStream = new DataInputStream(inputStream);
    }

    public PCAPHeader readHeader() throws InvalidPCAPFormat {
        if (this.pcapHeader != null) {
            return this.pcapHeader;
        }
        this.pcapHeader = new PCAPHeader();
        try {
            this.pcapHeader.setMagicNumber(Integer.toUnsignedLong(this.dataInputStream.readInt()));
            this.pcapHeader.setVersionMajor(Short.toUnsignedInt(this.dataInputStream.readShort()));
            this.pcapHeader.setVersionMinor(Short.toUnsignedInt(this.dataInputStream.readShort()));
            this.pcapHeader.setTimeZoneCorrection(this.dataInputStream.readInt());
            this.pcapHeader.setTimeStampAccuracy(Integer.toUnsignedLong(this.dataInputStream.readInt()));
            this.pcapHeader.setSnapLength(Integer.toUnsignedLong(this.dataInputStream.readInt()));
            int fcsInfo = Short.toUnsignedInt(this.dataInputStream.readShort());
            System.out.printf("FCS Info=%s\n", Integer.toBinaryString(fcsInfo));
            int fcs = fcsInfo & 0xE000;
            int fcsBit = fcsInfo & 0x1000;
            this.pcapHeader.setFrameCyclicSequence(fcs);
            this.pcapHeader.setFBit(fcsBit);
            this.pcapHeader.setDataLinkType(Short.toUnsignedInt(this.dataInputStream.readShort()));
        }
        catch (EOFException eof) {
            throw new InvalidPCAPFormat("The stream does not contain valid PCAP data.", eof);
        }
        catch (IOException ioe) {
            throw new InvalidPCAPFormat("There was a general error reading the Global PCAP Header data from the stream.", ioe);
        }
        return this.pcapHeader;
    }

    public PCAPPacket readNextPacket() throws InvalidPCAPFormat {
        if (this.pcapHeader == null) {
            this.readHeader();
        }
        PCAPPacket packet = new PCAPPacket();
        boolean startOfPacketRead = false;
        try {
            packet.setTimestampSeconds(Integer.toUnsignedLong(this.dataInputStream.readInt()));
            startOfPacketRead = true;
            packet.setTimestampSubSeconds(Integer.toUnsignedLong(this.dataInputStream.readInt()));
            packet.setCapturedPacketLength(Integer.toUnsignedLong(this.dataInputStream.readInt()));
            packet.setOriginalPacketLength(Integer.toUnsignedLong(this.dataInputStream.readInt()));
            byte[] packetData = new byte[(int)packet.getCapturedPacketLength()];
            int bytesRead = this.dataInputStream.read(packetData);
            packet.setPacketData(packetData);
        }
        catch (EOFException eof) {
            if (startOfPacketRead) {
                throw new InvalidPCAPFormat("Unexpected end of stream.  The stream does not contain valid PCAP data.", eof);
            }
            return null;
        }
        catch (IOException ioe) {
            throw new InvalidPCAPFormat("There was a general error reading the packet data from the stream.", ioe);
        }
        return packet;
    }

    public static void main(String[] args) {
        FileInputStreamHelper fin = new FileInputStreamHelper("/home/josephmmorgan/development/java/Projects/DPAA/PacketCaptures/prod-1/default/2021-07-06_23-13-51-capture.pcap");
        fin.open();
        PCAPReader pcapReader = new PCAPReader((InputStream)fin.getStream());
        try {
            try {
                PCAPHeader header = pcapReader.readHeader();
                System.out.printf("Header:\n%s\n%s\n\n", "=".repeat(80), header.toString());
                PCAPPacket packet = null;
                do {
                    if ((packet = pcapReader.readNextPacket()) == null) continue;
                    System.out.printf("Packet:\n%s\n%s\n\n", "=".repeat(80), packet.toString());
                } while (packet != null);
            }
            catch (Exception e) {
                e.printStackTrace();
                fin.close();
            }
        }
        finally {
            fin.close();
        }
    }
}

