/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.net;

import com.jmorgan.net.URLConnectionInfo;
import com.jmorgan.net.URLContent;
import com.jmorgan.net.URLStringContent;
import com.jmorgan.net.URLZipContent;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.StringUtility;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class URLReader {
    private URL url;
    private URLConnection connection;
    private URLConnectionInfo connectionInfo;
    private int method = 0;
    private HashMap<String, String> parameters = new HashMap();
    public static final int METHOD_GET = 0;
    public static final int METHOD_POST = 1;

    public URLReader() {
    }

    public URLReader(String url) throws MalformedURLException {
        this(url, 0);
    }

    public URLReader(String url, int method) throws MalformedURLException {
        this(new URL(url), method);
    }

    public URLReader(URL existingURL) {
        this(existingURL, 0);
    }

    public URLReader(URL existingURL, int method) {
        this();
        this.setUrl(existingURL);
        this.setMethod(method);
    }

    public URLReader(URL existingURL, URLConnection urlConnection) {
        this(existingURL);
        this.setConnection(urlConnection);
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL thisURL) {
        this.url = thisURL;
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public URLConnection getConnection() {
        return this.connection;
    }

    private void setConnection(URLConnection connection) {
        this.connection = connection;
    }

    public URLConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public URLContent<String> getData() {
        return this.readData();
    }

    public void setParameters(Map<String, String> hashMap) {
        this.parameters.clear();
        this.parameters.putAll(hashMap);
        this.setMethod(hashMap.size() == 0 ? 0 : 1);
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
        this.setMethod(1);
    }

    public void clearParameters() {
        this.parameters.clear();
        this.setMethod(0);
    }

    private URLContent<String> readData() throws IllegalStateException {
        if (this.url == null) {
            throw new IllegalStateException("The URL for URLReader has not been set.");
        }
        this.sendURLRequest();
        URLContent urlContent = null;
        String contentType = null;
        try {
            if (this.connection == null) {
                this.connection = this.url.openConnection();
            }
            this.connectionInfo = new URLConnectionInfo(this.connection);
            String declaredContentType = this.connectionInfo.getContentType();
            String contentEncoding = this.connectionInfo.getContentEncoding();
            if (declaredContentType == null) {
                System.out.println("URLReader.readData():  Declared ContentType null, or unknown for: " + String.valueOf(this.url));
                urlContent = new URLStringContent(this.connection);
            } else {
                int endOfString = declaredContentType.lastIndexOf(59);
                String string = contentType = endOfString == -1 ? declaredContentType : StringUtility.getLeftSubstring(declaredContentType, endOfString);
                if (contentEncoding != null && contentEncoding.equals("gzip") || contentType != null && Comparison.isIn(contentType, new String[]{"gzip", "application/x-gzip"})) {
                    urlContent = new URLZipContent(this.connection);
                } else if (Comparison.isIn(contentType.toLowerCase(), new String[]{"text/plain", "text/html", "text/xml", "application/xml", "application/rss+xml"})) {
                    urlContent = new URLStringContent(this.connection);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (urlContent == null) {
            System.out.println("URLReader.readData():  Unhandled ContentType encountered: " + contentType);
        }
        return urlContent;
    }

    private void sendURLRequest() {
        if (this.method == 0 || this.parameters.size() == 0) {
            return;
        }
        if (this.parameters.size() > 0) {
            try {
                StringBuilder sb = new StringBuilder();
                int iteration = 0;
                for (String key : this.parameters.keySet()) {
                    if (iteration > 0) {
                        sb.append("&");
                    }
                    sb.append(URLEncoder.encode(key, "UTF-8"));
                    sb.append("=");
                    sb.append(URLEncoder.encode(this.parameters.get(key), "UTF-8"));
                    ++iteration;
                }
                HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                conn.setDoOutput(true);
                conn.setDoInput(true);
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
                wr.write(sb.toString());
                wr.flush();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

