/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.net;

import com.jmorgan.beans.IPAddress;
import com.jmorgan.beans.JMBean;
import com.jmorgan.net.URLReader;
import com.jmorgan.net.URLStringContent;
import com.jmorgan.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class WhoIs
extends JMBean {
    private static final String[] patternBase = new String[]{"OrgName", "OrgI[Dd]", "Address", "City", "StateProv", "PostalCode", "Country", "Ref", "ReferralServer", "NetRange", "CIDR", "OriginAS", "NetName", "NetHandle", "Parent", "NetType", "NameServer", "Comment", "RegDate", "Updated", "OrgAbuseHandle", "OrgAbuseName", "OrgAbusePhone", "OrgAbuseEmail", "OrgAbuseRef", "OrgTechHandle", "OrgTechName", "OrgTechPhone", "OrgTechEmail", "OrgTechRef", "OrgNOCHandle", "OrgNOCName", "OrgNOCPhone", "OrgNCEmail", "OrgNOCRef", "RAbuseHandle", "RAbuseName", "RAbusePhone", "RAbuseEmail", "RAbuseRef", "RTechHandle", "RTechName", "RTechPhone", "RTechEmail", "RTechRef", "RNOCHandle", "RNOCName", "RNOCPhone", "RNCEmail", "RNOCRef"};
    private static final Pattern[] patterns = new Pattern[patternBase.length];
    private String ip;
    private ArrayList<Pair<String, String>> whoIsData;

    static {
        int i = 0;
        while (i < patternBase.length) {
            String stringPattern = "(" + patternBase[i] + "):\\s*(.*)";
            WhoIs.patterns[i] = Pattern.compile(stringPattern);
            ++i;
        }
    }

    public WhoIs(IPAddress ip) {
        this(ip.toString());
    }

    public WhoIs(String ip) {
        this.getWhoIsInfo(ip);
    }

    public String getIp() {
        return this.ip;
    }

    public ArrayList<Pair<String, String>> getData() {
        return this.whoIsData;
    }

    private void getWhoIsInfo(String ip) {
        this.ip = ip;
        try {
            URLReader reader = new URLReader("http://www.spfld.com/cgi-bin/whois?domain=" + ip + "&server=");
            String data = ((URLStringContent)reader.getData()).getContent();
            this.parseWhoIsInfo(data);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private void parseWhoIsInfo(String text) {
        this.whoIsData = new ArrayList();
        StringReader reader = new StringReader(text);
        BufferedReader br = new BufferedReader(reader);
        try {
            String line = null;
            int lineNo = 0;
            while ((line = br.readLine()) != null) {
                this.whoIsData.add(new Pair<CallSite, String>((CallSite)((Object)("Line " + ++lineNo)), line));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        String breaker = "=".repeat(80);
        StringBuilder sb = new StringBuilder(String.format("%s\nWhoIs Information for IP: %s\n%s\n", breaker, this.ip, breaker));
        for (Pair<String, String> pair : this.whoIsData) {
            sb.append((String)pair.first);
            sb.append(":\t");
            if (((String)pair.first).length() < 7) {
                sb.append('\t');
            }
            sb.append((String)pair.second);
            sb.append('\n');
        }
        return sb.toString();
    }
}

