/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.rules;

import com.jmorgan.rules.AbstractValueComparisonRule;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Pair;
import java.util.HashMap;

public abstract class AbstractPropertyValueRule<BeanType>
extends AbstractValueComparisonRule {
    private BeanType bean;
    private HashMap<String, Pair<Object, Integer>> valueMap;

    protected AbstractPropertyValueRule() {
        this.valueMap = new HashMap();
    }

    protected AbstractPropertyValueRule(BeanType bean) {
        this.setBean(bean);
        this.valueMap = new HashMap();
    }

    protected AbstractPropertyValueRule(BeanType bean, String propertyName, Object value) {
        this(bean);
        this.addPropertyValueMap(propertyName, value);
    }

    public BeanType getBean() {
        return this.bean;
    }

    public void setBean(BeanType bean) throws IllegalArgumentException {
        if (bean == null) {
            throw new IllegalArgumentException("The value for bean in " + this.getClass().getName() + " cannot be null.");
        }
        this.bean = bean;
    }

    public void addPropertyValueMap(String propertyName, Object value) {
        this.addPropertyValueMap(propertyName, value, 0);
    }

    public void addPropertyValueMap(String propertyName, Object value, int comparisonType) throws IllegalArgumentException {
        if (propertyName == null) {
            throw new IllegalArgumentException("The property name cannot be null in PropertyValueRule.addPropertyValueMap()");
        }
        this.valueMap.put(propertyName, new Pair<Object, Integer>(value, comparisonType));
    }

    public void addPropertyValueMap(String propertyName, Object value, String operator) throws IllegalArgumentException {
        if (propertyName == null) {
            throw new IllegalArgumentException("The property name cannot be null in PropertyValueRule.addPropertyValueMap()");
        }
        if (operator == null) {
            throw new IllegalArgumentException("The operator cannot be null in PropertyValueRule.addPropertyValueMap()");
        }
        int comparisonType = ArrayUtility.indexOf(operator.trim(), OPERATORS);
        if (comparisonType == -1) {
            throw new IllegalArgumentException("The operator " + operator + " is not valid in PropertyValueRule.addPropertyValueMap()");
        }
        this.valueMap.put(propertyName, new Pair<Object, Integer>(value, comparisonType));
    }

    public void removePropertyValueMap(String propertyName) {
        this.valueMap.remove(propertyName);
    }

    public void clearMap() {
        this.valueMap.clear();
    }

    public int getRuleCount() {
        return this.valueMap.size();
    }

    @Override
    public boolean isTrue() {
        if (this.bean == null) {
            throw new IllegalStateException("The bean from which to extract the property is null");
        }
        if (this.valueMap.size() == 0) {
            throw new IllegalStateException("There are no properties set for this " + this.getClass().getName() + ".");
        }
        for (String key : this.valueMap.keySet()) {
            Object eValue;
            Pair<Object, Integer> valuePair = this.valueMap.get(key);
            Object value = valuePair.first;
            int comparisonType = (Integer)valuePair.second;
            if (this.isTrue(value, comparisonType, eValue = this.getPropertyValue(this.bean, key))) continue;
            return false;
        }
        return true;
    }

    protected abstract Object getPropertyValue(BeanType var1, String var2);

    public String toString() {
        return "AbstractPropertyValueRule [bean=" + String.valueOf(this.bean) + "\nvalueMap=" + String.valueOf(this.valueMap) + "]";
    }
}

