/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.SearchDialogPane;
import com.jmorgan.swing.SearchDialogParameters;
import com.jmorgan.swing.layout.CellLayout;
import com.jmorgan.swing.layout.CellLayoutConstraints;
import java.awt.Component;
import java.awt.Dimension;

class DefaultSearchDialogPane
extends JMPanel
implements SearchDialogPane {
    private JMLabel searchLabel = new JMLabel("&Find");
    private JMTextField searchText = new JMTextField();
    private JMCheckBox caseSensitive;
    private static SearchDialogParameters lastSearch = null;

    public static SearchDialogParameters getLastSearchParameters() {
        DefaultSearchDialogPane.lastSearch.isNewSearch = false;
        return lastSearch;
    }

    public DefaultSearchDialogPane() {
        this.searchLabel.setLabelFor(this.searchText);
        this.caseSensitive = new JMCheckBox("&Match Case");
        this.setLayout(new CellLayout());
        this.add((Component)this.searchLabel, new CellLayoutConstraints(0, 0, 1, 1));
        this.add((Component)this.searchText, new CellLayoutConstraints(0, 1, 8, 1));
        this.add((Component)this.caseSensitive, new CellLayoutConstraints(1, 1, 8, 1));
        if (lastSearch != null) {
            this.setSearchParameters(lastSearch);
        }
        this.setPreferredSize(new Dimension(300, 35));
    }

    public DefaultSearchDialogPane(SearchDialogParameters parms) {
        this();
        this.setSearchParameters(parms);
    }

    @Override
    public void setSearchParameters(Object parms) throws NullPointerException, IllegalArgumentException {
        if (parms == null) {
            throw new NullPointerException("DefaultSearchDialogPane.setSearchParameters(Object parms):  \"parms\" cannot be null.");
        }
        if (!(parms instanceof SearchDialogParameters)) {
            throw new IllegalArgumentException("DefaultSearchDialogPane.setSearchParameters(Object parms):  \"parms\" must be an instance of SearchDialogParmeters");
        }
        SearchDialogParameters searchParms = (SearchDialogParameters)parms;
        if (searchParms.searchText != null) {
            this.searchText.setText(searchParms.searchText);
        }
        this.caseSensitive.setSelected(searchParms.isCaseSensitive);
    }

    @Override
    public Object getSearchParameters() {
        SearchDialogParameters parms = new SearchDialogParameters();
        parms.isNewSearch = lastSearch == null ? true : parms.searchText.equals(DefaultSearchDialogPane.lastSearch.searchText) && parms.isCaseSensitive == DefaultSearchDialogPane.lastSearch.isCaseSensitive;
        parms.searchText = this.searchText.getText();
        parms.isCaseSensitive = this.caseSensitive.isSelected();
        lastSearch = parms;
        return parms;
    }
}

