/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.ExitButton;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTextArea;
import com.jmorgan.swing.PictureControl;
import com.jmorgan.swing.decorator.ArrowDecorator;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.util.WindowCloser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.ImageIcon;

public class ExceptionDialog
extends JMDialog {
    private static boolean WAS_CANCELLED;
    private static final int SMALL_HEIGHT = 132;
    private JMPanel exceptionTextPanel;
    private int lastHeight;
    private JMButton detailsButton;
    private ArrowDecorator arrowDecorator;

    public static boolean wasCancelled() {
        return WAS_CANCELLED;
    }

    public ExceptionDialog(Window owner, String title, String message, Exception exception) {
        super(owner, title, true, new Object[]{message, exception});
    }

    @Override
    public void buildGUI(Object ... arguments) {
        WAS_CANCELLED = false;
        String message = (String)arguments[0];
        Exception exception = (Exception)arguments[1];
        this.lastHeight = 328;
        String imageFileName = GUIApplication.getGUIApplication().getArtRoot() + "Error.png";
        ImageIcon imageIcon = new ImageIcon(imageFileName);
        PictureControl icon = new PictureControl(imageIcon.getImage());
        icon.setPreferredSize(new Dimension(80, 80));
        JMTextArea messageTA = new JMTextArea(message);
        messageTA.setEditable(false);
        ExitButton okButton = new ExitButton("&OK", false, 0);
        this.detailsButton = new JMButton("&Details   ");
        this.arrowDecorator = new ArrowDecorator(3);
        this.arrowDecorator.setXAdjust(20);
        this.detailsButton.setDecorator(this.arrowDecorator);
        new ActionEventInvoker(this.detailsButton, this, "toggleDetailsPanel");
        JMButton cancelButton = new JMButton("&Cancel");
        new ActionEventInvoker(cancelButton, this, "cancel");
        JMPanel buttonPanel = new JMPanel(new VerticalFlowLayout(3));
        buttonPanel.setBackground(Color.white);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        buttonPanel.add(this.detailsButton);
        JMPanel topPanel = new JMPanel(new BorderLayout(5, 5));
        topPanel.setBackground(Color.white);
        topPanel.setInsets(new Insets(5, 5, 0, 5));
        topPanel.add((Component)icon, "West");
        topPanel.add((Component)messageTA, "Center");
        topPanel.add((Component)buttonPanel, "East");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bout);
        exception.printStackTrace(ps);
        JMTextArea exceptionTA = new JMTextArea(bout.toString());
        exceptionTA.setEditable(false);
        this.exceptionTextPanel = new JMPanel(new BorderLayout());
        this.exceptionTextPanel.setBackground(Color.white);
        this.exceptionTextPanel.add((Component)new JMScrollPane(exceptionTA), "Center");
        this.exceptionTextPanel.setPreferredSize(new Dimension(400, 200));
        this.exceptionTextPanel.setInsets(new Insets(0, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(5, 5));
        this.contentPane.setBackground(Color.white);
        this.contentPane.add((Component)topPanel, "North");
        this.contentPane.add((Component)this.exceptionTextPanel, "Center");
        new AsynchMethodInvoker((Object)this, "adjustHeight", 50);
    }

    @Reflected
    private void cancel() {
        WAS_CANCELLED = true;
        WindowCloser.closeWindow(this);
    }

    public void adjustHeight() {
        this.setSize(this.getWidth(), 132);
    }

    public void toggleDetailsPanel() {
        if (this.getHeight() == 132) {
            this.arrowDecorator.setDirection(7);
            this.detailsButton.invalidate();
            this.setSize(this.getWidth(), this.lastHeight);
        } else {
            this.lastHeight = this.getHeight();
            this.arrowDecorator.setDirection(3);
            this.detailsButton.invalidate();
            this.setSize(this.getWidth(), 132);
        }
    }
}

