/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.WindowCloser;
import java.awt.Window;

public class ExitButton
extends JMButton {
    private boolean promptOnClose = true;
    private int closeAction = 1;

    public ExitButton() {
        this("Exit");
    }

    public ExitButton(String label) {
        this(label, true);
    }

    public ExitButton(String label, boolean promptOnClose) {
        this(label, true, 1);
    }

    public ExitButton(String label, boolean promptOnClose, int closeAction) {
        super(label);
        new ActionEventInvoker(this, this, "buttonClicked");
        this.promptOnClose = promptOnClose;
        this.closeAction = closeAction;
    }

    public boolean isPromptOnClose() {
        return this.promptOnClose;
    }

    public void setPromptOnClose(boolean promptOnClose) {
        this.promptOnClose = promptOnClose;
    }

    public int getCloseAction() {
        return this.closeAction;
    }

    public void setCloseAction(int closeAction) {
        this.closeAction = closeAction;
    }

    public boolean preClicked() {
        return true;
    }

    public void buttonClicked() {
        if (!this.preClicked()) {
            return;
        }
        Window w = GUIServices.getParentWindow(this);
        WindowCloser.closeWindow(w, this.closeAction, this.promptOnClose);
    }
}

