/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.lang.Application;
import com.jmorgan.swing.MainPanel;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.swing.util.WindowCloser;
import com.jmorgan.util.ThreadUtility;
import java.awt.Container;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class JMDialog
extends JDialog {
    protected static Logger applicationLogger;
    protected Container contentPane;
    private boolean defaultSizing = true;
    private int closeOperation;
    private boolean queryOnClose;
    protected WindowCloser windowCloser;

    public JMDialog() {
        this(new Object[0]);
    }

    public JMDialog(JDialog owner) {
        this(owner, "", false);
    }

    public JMDialog(JDialog owner, boolean modality) {
        this(owner, "", modality);
    }

    public JMDialog(JDialog owner, String title) {
        this(owner, title, false);
    }

    public JMDialog(JDialog owner, String title, boolean modality) {
        super(owner, title, modality);
        this.standardInit(new Object[0]);
    }

    public JMDialog(JFrame owner) {
        this(owner, "", false);
    }

    public JMDialog(JFrame owner, boolean modality) {
        this(owner, "", modality);
    }

    public JMDialog(JFrame owner, String title) {
        this(owner, title, false);
    }

    public JMDialog(JFrame owner, String title, boolean modality) {
        super(owner, title, modality);
        this.standardInit(new Object[0]);
    }

    public JMDialog(Object ... arguments) {
        this.standardInit(arguments);
    }

    public JMDialog(JDialog owner, Object ... arguments) {
        this(owner, "", false, arguments);
    }

    public JMDialog(JDialog owner, boolean modality, Object ... arguments) {
        this(owner, "", modality, arguments);
    }

    public JMDialog(JDialog owner, String title, Object ... arguments) {
        this(owner, title, false, arguments);
    }

    public JMDialog(JDialog owner, String title, boolean modality, Object ... arguments) {
        super(owner, title, modality);
        this.standardInit(arguments);
    }

    public JMDialog(JFrame owner, Object ... arguments) {
        this(owner, "", false, arguments);
    }

    public JMDialog(JFrame owner, boolean modality, Object ... arguments) {
        this(owner, "", modality, arguments);
    }

    public JMDialog(JFrame owner, String title, Object ... arguments) {
        this(owner, title, false, arguments);
    }

    public JMDialog(JFrame owner, String title, boolean modality, Object ... arguments) {
        super(owner, title, modality);
        this.standardInit(arguments);
    }

    public void buildGUI(Object ... arguments) {
    }

    public void setDefaultSizing(boolean state) {
        this.defaultSizing = state;
    }

    public void setupEventHandling() {
    }

    public WindowCloser getWindowCloser() {
        return this.windowCloser;
    }

    public void setCloseOperation(int closeOperation) {
        this.closeOperation = closeOperation;
    }

    public int getCloseOperation() {
        return 0;
    }

    public boolean getQueryOnClose() {
        return false;
    }

    protected boolean getDefaultSizing() {
        return this.defaultSizing;
    }

    protected boolean getInitialVisibility() {
        return true;
    }

    protected int getInsetsSize() {
        return 5;
    }

    protected void standardInit(Object ... arguments) {
        JMDialog.getApplicationLogger();
        if (applicationLogger == null) {
            applicationLogger = Logger.getLogger(this.getClass().getSimpleName());
        }
        this.closeOperation = this.getCloseOperation();
        this.queryOnClose = this.getQueryOnClose();
        MainPanel contentPanel = new MainPanel();
        contentPanel.setInsets(InsetsFactory.createFixedInsets(5));
        this.setContentPane(contentPanel);
        this.contentPane = contentPanel;
        this.windowCloser = new WindowCloser(this, this.closeOperation, this.queryOnClose);
        this.buildGUI(arguments);
        this.setupEventHandling();
        this.defaultSizing = this.getDefaultSizing();
        if (this.defaultSizing) {
            this.initializeSize();
        }
        this.setVisible(this.getInitialVisibility());
    }

    protected void initializeSize() {
        this.pack();
        this.centerOnParent();
    }

    protected void centerOnParent() {
        Container owner = this.getParent();
        if (owner == null) {
            GUIServices.centerWindow(this);
        } else {
            this.setLocationRelativeTo(owner);
        }
    }

    protected static Logger getApplicationLogger() {
        if (applicationLogger != null) {
            return applicationLogger;
        }
        int attempts = 0;
        while (applicationLogger == null && attempts++ < 10) {
            Application application = Application.getApplication();
            applicationLogger = application != null ? application.getApplicationLogger() : null;
            ThreadUtility.sleep(50L);
        }
        if (applicationLogger != null) {
            applicationLogger.fine(String.format("JMDialog got the application logger after %d attempts", attempts - 1));
        }
        return applicationLogger;
    }
}

