/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.io.File;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.AboutDialog;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.dialog.uiconstants.UIConstantsDialog;
import com.jmorgan.swing.menu.FrameMenuBar;
import com.jmorgan.swing.menu.MenuBarListenerService;
import com.jmorgan.swing.menu.MenuStateService;
import com.jmorgan.swing.menu.StandardMenuListener;
import com.jmorgan.swing.menu.ToolBarGenerator;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.WindowCloser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public class JMFrame
extends JFrame {
    private PrinterJob printerJob;
    protected JMenuBar menuBar;
    protected JToolBar toolBar;
    protected Container contentPane;
    protected Container guiPane;
    protected ActionListener menuListener;
    protected WindowCloser windowCloser;
    private Insets insets;

    public JMFrame() {
        this("");
    }

    public JMFrame(String title) {
        super(title);
        this.setFrameIcon();
        this.contentPane = this.getContentPane();
        this.menuBar = this.buildMenuBar();
        MenuBarListenerService mls = new MenuBarListenerService(this.menuBar);
        this.menuListener = this.buildMenuActionListener();
        mls.addActionListener(this.menuListener);
        this.setJMenuBar(this.menuBar);
        this.toolBar = this.buildToolBar();
        if (this.toolBar != null) {
            this.contentPane.add((Component)this.toolBar, "North");
        }
        this.guiPane = this.buildGUI();
        this.contentPane.add((Component)this.guiPane, "Center");
        this.setupEventHandling();
        this.pack();
        GUIServices.centerWindow(this);
        this.setVisible(true);
        new MenuStateService(this.menuBar);
    }

    public void setupEventHandling() {
        this.setDefaultCloseOperation(0);
        this.windowCloser = new WindowCloser(this, 1);
    }

    public WindowCloser getWindowCloser() {
        return this.windowCloser;
    }

    public JMenuBar buildMenuBar() {
        return new FrameMenuBar();
    }

    public ActionListener buildMenuActionListener() {
        return new StandardMenuListener();
    }

    public JToolBar buildToolBar() {
        ToolBarGenerator tbg = new ToolBarGenerator(this.menuBar);
        return tbg.getToolBar();
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public Container buildGUI() {
        JMPanel panel = new JMPanel();
        panel.setPreferredSize(new Dimension(100, 100));
        return panel;
    }

    protected String getApplicationIconFileName() {
        return "./ApplicationIcon.jpg";
    }

    protected void setFrameIcon() {
        String iconFileName = this.getApplicationIconFileName();
        File iconFile = new File(iconFileName);
        if (!iconFile.exists()) {
            return;
        }
        try {
            ImageIcon icon = new ImageIcon(iconFileName);
            this.setIconImage(icon.getImage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void filePrintSetup() {
        this.printerJob = PrinterJob.getPrinterJob();
        boolean dialogAccepted = this.printerJob.printDialog();
        if (dialogAccepted) {
            System.out.println("JMFrame.filePrintSetup(): Dialog accepted");
        }
    }

    public void fileExit() {
        WindowCloser.closeWindow(this, 1);
    }

    public void optionsJavaLookAndFeel() {
        GUIApplication.setJavaLookAndFeel();
    }

    public void optionsWindowsLookAndFeel() {
        GUIApplication.setWindowsLookAndFeel();
    }

    public void optionsMotifLookAndFeel() {
        GUIApplication.setMotifLookAndFeel();
    }

    public void optionsUIPreferences() {
        new UIConstantsDialog(this);
    }

    public void helpAbout() {
        new AboutDialog(this);
    }

    public Image getAboutDialogIcon() {
        return this.getIconImage();
    }

    public void helpApplicationLogDiagnostic() {
        Application.getApplication().setApplicationLogLevel(Level.FINEST);
    }

    public void helpApplicationLogDebug() {
        Application.getApplication().setApplicationLogLevel(Level.FINER);
    }

    public void helpApplicationLogInfo() {
        Application.getApplication().setApplicationLogLevel(Level.CONFIG);
    }

    public void helpApplicationLogError() {
        Application.getApplication().setApplicationLogLevel(Level.INFO);
    }

    public boolean canExit() {
        return true;
    }

    public Container getGUIPane() {
        return this.guiPane;
    }

    public ActionListener getMenuListener() {
        return this.menuListener;
    }

    @Override
    public Insets getInsets() {
        if (this.insets == null) {
            return super.getInsets();
        }
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }
}

