/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.awt.RectangleShapeCreator;
import com.jmorgan.awt.ShapeCreator;
import com.jmorgan.awt.ShapePainter;
import com.jmorgan.swing.decorator.Decorator;
import com.jmorgan.swing.event.ComponentEventInvoker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JMPanel
extends JPanel {
    private Insets insets;
    private Decorator decorator;
    private ShapeCreator shapeCreator;
    private ShapePainter shapePainterDelegate;
    private Paint backgroundPaint;

    public JMPanel() {
        this(new FlowLayout());
    }

    public JMPanel(LayoutManager layout) {
        super(layout);
        ShapeCreator shapeCreator = (ShapeCreator)UIManager.get("Panel.shapeCreator");
        if (shapeCreator != null) {
            this.setShapeCreator(shapeCreator);
        }
        new ComponentEventInvoker(this, 8, (Object)this, "componentResized");
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.setOpaque(this.backgroundPaint == null);
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(Decorator decorator) {
        this.decorator = decorator;
    }

    @Override
    public Insets getInsets() {
        if (this.insets == null) {
            return super.getInsets();
        }
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    @Reflected
    public void componentResized() {
        this.shapePainterDelegate = null;
    }

    @Override
    public void setSize(Dimension d) {
        this.shapePainterDelegate = null;
        super.setSize(d);
    }

    @Override
    public void setSize(int width, int height) {
        this.shapePainterDelegate = null;
        super.setSize(width, height);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void addAll(Component ... components) {
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            this.add(c);
            ++n2;
        }
    }

    public void addAll(int componentIndex, Component ... components) {
        int i = components.length - 1;
        while (i >= 0) {
            this.add(components[i], componentIndex);
            --i;
        }
    }

    public ShapeCreator getShapeCreator() {
        return this.shapeCreator;
    }

    public void setShapeCreator(ShapeCreator shapeCreator) {
        this.shapePainterDelegate = null;
        this.shapeCreator = shapeCreator;
    }

    @Override
    protected void paintBorder(Graphics g) {
        if (this.shapeCreator != null) {
            if (this.shapePainterDelegate == null) {
                this.shapePainterDelegate = new ShapePainter(this, this.shapeCreator.createShape(this.getBounds()));
            }
            this.shapePainterDelegate.paintBorder(g);
        } else {
            super.paintBorder(g);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Paint oldPaint = null;
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            if (this.backgroundPaint != null) {
                oldPaint = g2d.getPaint();
                g2d.setPaint(this.backgroundPaint);
                if (this.shapeCreator == null) {
                    this.setShapeCreator(new RectangleShapeCreator());
                }
            }
        } else {
            g.setColor(this.getBackground());
        }
        if (this.shapeCreator != null) {
            if (this.shapePainterDelegate == null) {
                this.shapePainterDelegate = new ShapePainter(this, this.shapeCreator.createShape(this.getBounds()));
            }
            this.shapePainterDelegate.paintComponent(g);
        }
        super.paintComponent(g);
        if (this.backgroundPaint != null && g2d != null) {
            g2d.setPaint(oldPaint);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.decorator != null) {
            this.decorator.paint(g, this);
        }
    }
}

