/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.lang.GUIApplicationProperties;
import com.jmorgan.swing.PictureControl;
import com.jmorgan.swing.event.ComponentEventInvoker;
import com.jmorgan.swing.event.FocusChangePropertyChangeNotifier;
import com.jmorgan.swing.event.KeyEventDispatcherInvoker;
import com.jmorgan.swing.util.FocusSelector;
import com.jmorgan.util.StringUtility;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JPasswordField;
import javax.swing.text.Document;

public class JMPasswordField
extends JPasswordField
implements PropertyChangeNotifier {
    private static final ImageIcon CAPS_ON;
    private static final ImageIcon CAPS_OFF;
    private PictureControl capsLockIcon;
    protected PropertyChangeSupport propertyChangeSupport;

    static {
        String artRoot = null;
        GUIApplication guiApplication = GUIApplication.getGUIApplication();
        if (guiApplication != null) {
            GUIApplicationProperties guiAppProps = (GUIApplicationProperties)((Object)GUIApplication.getGUIApplication().getApplicationProperties());
            artRoot = guiAppProps.getArtRootDirectory();
        } else {
            artRoot = "./resources/";
        }
        CAPS_ON = new ImageIcon(GUIApplication.getMenuResource(artRoot, "AllCaps.png"));
        CAPS_OFF = new ImageIcon(GUIApplication.getMenuResource(artRoot, "SmallCaps.png"));
    }

    public JMPasswordField() {
        this.standardInit();
    }

    public JMPasswordField(String text) {
        super(text);
        this.standardInit();
    }

    public JMPasswordField(int columns) {
        super(columns);
        this.standardInit();
    }

    public JMPasswordField(String text, int columns) {
        super(text, columns);
        this.standardInit();
    }

    public JMPasswordField(Document doc, String txt, int columns) {
        super(doc, txt, columns);
        this.standardInit();
    }

    @Override
    public String getText() {
        return new String(this.getPassword());
    }

    @Override
    public void setText(String t) {
        String oldText = new String(this.getPassword());
        super.setText(t);
        this.firePropertyChange(oldText, t);
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void firePropertyChange(String oldText, String newText) {
        if (this.propertyChangeSupport != null && oldText != null && !oldText.equals(newText)) {
            String fieldName = this.getName();
            this.propertyChangeSupport.firePropertyChange(StringUtility.isEmpty(fieldName) ? "password" : fieldName, oldText, newText);
        }
    }

    void standardInit() {
        this.setName("password");
        this.capsLockIcon = new PictureControl();
        this.add((Component)this.capsLockIcon, 0);
        this.setComponentZOrder(this.capsLockIcon, 0);
        new FocusSelector(this);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        new FocusChangePropertyChangeNotifier(this);
        new AsynchMethodInvoker((Object)this, "waitForParent");
        KeyEventDispatcherInvoker capsLockInvoker = new KeyEventDispatcherInvoker(KeyboardFocusManager.getCurrentKeyboardFocusManager(), this, "checkCapsLockState");
        capsLockInvoker.addTriggeringKeyCodes(20);
    }

    @Reflected
    private void waitForParent() {
        Container parent = this.getParent();
        if (parent == null) {
            new AsynchMethodInvoker((Object)this, "waitForParent", 250);
            return;
        }
        new ComponentEventInvoker(parent, 2, (Object)this, "checkCapsLockState");
        new AsynchMethodInvoker((Object)this, "checkCapsLockState", 100);
    }

    @Reflected
    private void checkCapsLockState() {
        boolean isOn = Toolkit.getDefaultToolkit().getLockingKeyState(20);
        ImageIcon displayedIcon = isOn ? CAPS_ON : CAPS_OFF;
        this.capsLockIcon.setIcon(displayedIcon);
        Rectangle thisPosition = this.getBounds();
        int iconX = thisPosition.width - 22;
        int iconY = 5;
        Rectangle iconPosition = new Rectangle(iconX, iconY, 16, 16);
        this.capsLockIcon.setBounds(iconPosition);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

