/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.swing.JMComboBox;
import com.jmorgan.swing.JMLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class SimpleColorChooser
extends JMComboBox<Color> {
    public SimpleColorChooser(Color[] colors) {
        this.setColors(colors);
    }

    public SimpleColorChooser(int scale) throws IllegalArgumentException {
        if (scale < 1) {
            throw new IllegalArgumentException("Scale cannot be < 1.");
        }
        Color[] colors = new Color[(int)Math.pow(256 / scale, 3.0)];
        int r = 0;
        int n = 0;
        while (r < 256) {
            int g = 0;
            while (g < 256) {
                int b = 0;
                while (b < 256) {
                    colors[n] = new Color(r, g, b);
                    b += scale;
                    ++n;
                }
                g += scale;
            }
            r += scale;
        }
        this.setColors(colors);
    }

    private void setColors(Color[] colors) {
        this.setProgramStateChange(true);
        this.setRenderer(new SimpleColorChooserRenderer());
        int i = 0;
        while (i < colors.length) {
            this.addItem(colors[i]);
            ++i;
        }
        this.setProgramStateChange(false);
        Dimension pref = this.getPreferredSize();
        pref.width = 50;
        pref.height = 24;
        this.setPreferredSize(pref);
    }

    public Color getColorSelected() {
        return (Color)this.getSelectedItem();
    }

    private class SimpleColorChooserRenderer
    extends JMLabel
    implements ListCellRenderer<Color> {
        Border blackBorder = BorderFactory.createLineBorder(Color.black);
        Border whiteBorder = BorderFactory.createLineBorder(Color.white);
        boolean paintingIndex = false;

        SimpleColorChooserRenderer() {
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(45, 18));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Color> list, Color value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index == -1) {
                this.setBorder(this.blackBorder);
                this.paintingIndex = true;
                this.invalidate();
            } else {
                this.setBorder(isSelected ? this.whiteBorder : this.blackBorder);
                this.setBackground(value);
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (!this.paintingIndex) {
                return;
            }
            Dimension d = this.getSize();
            g.setColor(SimpleColorChooser.this.getColorSelected());
            g.fillRect(0, 0, d.width, d.height);
            this.paintingIndex = false;
        }
    }
}

