/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.calendar.ArrowPanel;
import com.jmorgan.swing.calendar.model.CalendarModel;
import com.jmorgan.swing.combobox.MonthComboBox;
import com.jmorgan.swing.combobox.YearComboBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.border.LineBorder;

class MonthHeader
extends JMPanel
implements PropertyChangeListener,
ActionListener {
    private ArrowPanel priorPanel;
    private ArrowPanel nextPanel;
    private MonthComboBox monthChoice;
    private YearComboBox yearChoice;
    private PropertyChangeSupport propertyChangeSupport;
    private Calendar oldValue;
    private JMPanel centerPanel;

    public MonthHeader() {
        super(new BorderLayout());
        this.setBorder(new LineBorder(Color.BLACK));
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.priorPanel = new ArrowPanel(7);
        this.priorPanel.addActionListener(this);
        this.add((Component)this.priorPanel, "West");
        this.centerPanel = new JMPanel();
        this.monthChoice = new MonthComboBox();
        this.yearChoice = new YearComboBox();
        this.centerPanel.add(this.monthChoice);
        this.centerPanel.add(this.yearChoice);
        this.add((Component)this.centerPanel, "Center");
        this.nextPanel = new ArrowPanel(3);
        this.nextPanel.addActionListener(this);
        this.add((Component)this.nextPanel, "East");
        this.monthChoice.addPropertyChangeListener(this);
        this.yearChoice.addPropertyChangeListener(this);
    }

    public void setMonth(Calendar date) {
        int month = date.get(2);
        int year = date.get(1);
        this.monthChoice.setMonthNumber(month);
        this.yearChoice.setYear(year);
    }

    public void setCalendarModel(CalendarModel model) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        new AsynchMethodInvoker((Object)this, "showComponents", 2000);
        this.firePropertyChangeEvent();
    }

    @Reflected
    public void showComponents() {
        if (!this.monthChoice.isVisible() || !this.yearChoice.isVisible()) {
            this.monthChoice.setVisible(true);
            this.yearChoice.setVisible(true);
        } else if (this.isShowing() && this.isVisible()) {
            new AsynchMethodInvoker((Object)this, "showComponents", 2000);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int monthNumber;
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("priormonth")) {
            monthNumber = this.monthChoice.getMonthNumber();
            this.monthChoice.setMonthNumber(monthNumber - 1);
            if (monthNumber < this.monthChoice.getMonthNumber()) {
                this.yearChoice.setYear(this.yearChoice.getYear() - 1);
            }
        }
        if (actionCommand.equals("nextmonth")) {
            monthNumber = this.monthChoice.getMonthNumber();
            this.monthChoice.setMonthNumber(monthNumber + 1);
            if (monthNumber > this.monthChoice.getMonthNumber()) {
                this.yearChoice.setYear(this.yearChoice.getYear() + 1);
            }
        }
        if (actionCommand.equals("prioryear")) {
            this.yearChoice.setYear(this.yearChoice.getYear() - 1);
        }
        if (actionCommand.equals("nextyear")) {
            this.yearChoice.setYear(this.yearChoice.getYear() + 1);
        }
        this.firePropertyChangeEvent();
    }

    private void firePropertyChangeEvent() {
        int month = this.monthChoice.getMonthNumber();
        int year = this.yearChoice.getYear();
        GregorianCalendar c = new GregorianCalendar(year, month, 1);
        this.propertyChangeSupport.firePropertyChange("date", this.oldValue, c);
        this.oldValue = c;
    }
}

