/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar;

import com.jmorgan.swing.calendar.CalendarSelectionListener;
import com.jmorgan.swing.calendar.MonthDetail;
import com.jmorgan.swing.calendar.MonthHeader;
import com.jmorgan.swing.calendar.model.CalendarModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class MonthUI
extends JPanel
implements PropertyChangeListener,
CalendarSelectionListener {
    private MonthHeader monthHeader;
    private MonthDetail monthDetail;

    MonthUI(String className) throws ClassNotFoundException {
        this.setLayout(new BorderLayout());
        this.setBorder(new LineBorder(Color.BLACK));
        this.monthHeader = new MonthHeader();
        this.monthHeader.addPropertyChangeListener(this);
        this.add((Component)this.monthHeader, "North");
        this.monthDetail = new MonthDetail(className);
        this.add((Component)this.monthDetail, "Center");
        Calendar monthToShow = Calendar.getInstance();
        monthToShow.set(5, 1);
        this.monthDetail.setDate(monthToShow);
        this.monthDetail.addCalendarSelectionListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.monthDetail.setDate((Calendar)evt.getNewValue());
    }

    public void setCalendarModel(CalendarModel model) {
        this.monthHeader.setCalendarModel(model);
        this.monthDetail.setCalendarModel(model);
    }

    public void setDate(Calendar date) {
        this.monthHeader.setMonth(date);
        this.monthDetail.setDate(date);
    }

    public void addCalendarSelectionListener(CalendarSelectionListener listener) {
        this.monthDetail.addCalendarSelectionListener(listener);
    }

    public MonthDetail getMonthDetail() {
        return this.monthDetail;
    }

    public MonthHeader getMonthHeader() {
        return this.monthHeader;
    }

    @Override
    public void dateSelected(Calendar date) {
        this.monthHeader.setMonth(date);
    }
}

