/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar.model;

import com.jmorgan.math.DateMath;
import com.jmorgan.swing.calendar.model.RecurrencePattern;
import com.jmorgan.swing.calendar.model.WeekDayOccurrence;
import com.jmorgan.util.Date;
import java.util.ArrayList;

public class MonthlyRecurrencePattern
extends RecurrencePattern {
    private ArrayList<Integer> fixedDates = new ArrayList();
    private ArrayList<WeekDayOccurrence> weekDays = new ArrayList();

    public MonthlyRecurrencePattern(Date startDate) {
        this(startDate, 1);
    }

    public MonthlyRecurrencePattern(Date startDate, int frequency) {
        super(startDate, frequency);
    }

    public void addFixedDate(int day) throws IllegalArgumentException {
        if (day <= 0 || day > 31) {
            throw new IllegalArgumentException("Day cannot be less than 0 or greater than 31");
        }
        this.fixedDates.add(new Integer(day));
    }

    public int[] getFixedDates() {
        int[] fixed = new int[this.fixedDates.size()];
        int j = 0;
        for (Integer date : this.fixedDates) {
            fixed[j++] = date;
        }
        return fixed;
    }

    public void removedFixedDate(int day) {
        this.fixedDates.remove(new Integer(day));
    }

    public void addWeekDay(int weekDay, int occurrence) throws IllegalArgumentException {
        this.weekDays.add(new WeekDayOccurrence(weekDay, occurrence));
    }

    public WeekDayOccurrence[] getWeekdayOccurrences() {
        return (WeekDayOccurrence[])this.weekDays.toArray();
    }

    public void setWeekDay(int index, int day) {
        if (this.weekDays.size() <= index) {
            this.addWeekDay(day, 0);
        }
        WeekDayOccurrence occurrence = this.weekDays.get(index);
        occurrence.setWeekDay(day);
    }

    public void setOccurrence(int index, int occurs) {
        if (this.weekDays.size() <= index) {
            this.addWeekDay(0, occurs);
        }
        WeekDayOccurrence occurrence = this.weekDays.get(index);
        occurrence.setOccurrence(occurs);
    }

    public void removeWeekDay(int weekDay, int occurrence) throws IllegalArgumentException {
        this.weekDays.remove(new WeekDayOccurrence(weekDay, occurrence));
    }

    @Override
    public boolean isValidDate(Date targetDate) {
        if (!super.isValidDate(targetDate)) {
            return false;
        }
        int targetMonth = targetDate.getMonth();
        int targetDay = targetDate.getDay();
        int targetYear = targetDate.getYear();
        int freq = this.getRecurrenceFrequency();
        Date workingDate = (Date)this.getStartDate().clone();
        workingDate.setDay(1);
        while (workingDate.isBefore(targetDate)) {
            if (workingDate.getMonth() == targetMonth && workingDate.getYear() == targetYear) break;
            workingDate.addMonths(freq);
        }
        if (workingDate.isAfter(targetDate)) {
            return false;
        }
        for (Integer integerDay : this.fixedDates) {
            int day = integerDay;
            if (day != targetDay) continue;
            return true;
        }
        int workingMonth = workingDate.getMonth();
        int workingYear = workingDate.getYear();
        for (WeekDayOccurrence weekDayOccurrence : this.weekDays) {
            Date weekDate = DateMath.getWeekdayOcurrence(weekDayOccurrence.getOccurrence(), weekDayOccurrence.getWeekDay(), workingMonth, workingYear);
            if (!weekDate.equals(targetDate)) continue;
            return true;
        }
        return false;
    }
}

