/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar.model;

import com.jmorgan.swing.calendar.model.RecurrencePattern;
import com.jmorgan.util.Date;

public class WeeklyRecurrencePattern
extends RecurrencePattern {
    private boolean onSunday;
    private boolean onMonday;
    private boolean onTuesday;
    private boolean onWednesday;
    private boolean onThursday;
    private boolean onFriday;
    private boolean onSaturday;

    public WeeklyRecurrencePattern(Date startDate) {
        super(startDate);
    }

    public WeeklyRecurrencePattern(Date startDate, int frequency) {
        super(startDate, frequency);
    }

    public boolean isDaySelected(int dayOfWeek) {
        switch (dayOfWeek) {
            case 1: {
                return this.onSunday;
            }
            case 2: {
                return this.onMonday;
            }
            case 3: {
                return this.onTuesday;
            }
            case 4: {
                return this.onWednesday;
            }
            case 5: {
                return this.onThursday;
            }
            case 6: {
                return this.onFriday;
            }
            case 7: {
                return this.onSaturday;
            }
        }
        return false;
    }

    public void setDayOfWeek(int dayOfWeek, boolean state) {
        switch (dayOfWeek) {
            case 1: {
                this.onSunday = state;
            }
            case 2: {
                this.onMonday = state;
            }
            case 3: {
                this.onTuesday = state;
            }
            case 4: {
                this.onWednesday = state;
            }
            case 5: {
                this.onThursday = state;
            }
            case 6: {
                this.onFriday = state;
            }
            case 7: {
                this.onSaturday = state;
            }
        }
    }

    @Override
    public boolean isValidDate(Date date) {
        if (!super.isValidDate(date)) {
            return false;
        }
        int freg = this.getRecurrenceFrequency();
        Date startDate = (Date)this.getStartDate().clone();
        while (startDate.isBefore(date)) {
            startDate.addDays(freg * 7);
        }
        if (!startDate.equals(date)) {
            return false;
        }
        switch (date.getCalendar().get(7)) {
            case 1: {
                return this.onSunday;
            }
            case 2: {
                return this.onMonday;
            }
            case 3: {
                return this.onTuesday;
            }
            case 4: {
                return this.onWednesday;
            }
            case 5: {
                return this.onThursday;
            }
            case 6: {
                return this.onFriday;
            }
            case 7: {
                return this.onSaturday;
            }
        }
        return false;
    }
}

