/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.combobox;

import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.decorator.ArrowDecorator;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.UIManager;

class DefaultComboBoxButton
extends JMButton {
    private Color arrowColor;
    private Color disabledArrowColor;

    public DefaultComboBoxButton() {
        this.setBackground(UIManager.getColor("ComboBox.buttonBackground"));
        this.setPreferredSize(new Dimension(16, 16));
        this.arrowColor = UIManager.getColor("ComboBox.arrowColor");
        if (this.arrowColor == null) {
            this.arrowColor = Color.BLACK;
        }
        this.disabledArrowColor = UIManager.getColor("ComboBox.disabledArrowColor");
        if (this.disabledArrowColor == null) {
            this.disabledArrowColor = Color.LIGHT_GRAY;
        }
        ArrowDecorator arrowDecorator = new ArrowDecorator();
        arrowDecorator.setArrowColor(this.arrowColor);
        this.setDecorator(arrowDecorator);
    }

    public DefaultComboBoxButton(Icon icon) {
        this(icon, "Display Choices");
    }

    public DefaultComboBoxButton(Icon icon, String toolTipText) {
        super(icon, toolTipText);
        this.setPreferredSize(new Dimension(16, 16));
        this.setDecorator(new ArrowDecorator());
    }

    @Override
    public void setEnabled(boolean state) {
        super.setEnabled(state);
        ArrowDecorator decorator = (ArrowDecorator)this.getDecorator();
        decorator.setArrowColor(state ? this.arrowColor : this.disabledArrowColor);
    }
}

