/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.component;

import com.jmorgan.awt.ShapeCreator;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.beans.util.PropertyChangeInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.jmorgan.swing.event.KeyEventInvoker;
import com.jmorgan.swing.menu.JMMenuItem;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.StringUtility;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.undo.UndoManager;

public final class ComponentFactory {
    private ComponentFactory() {
    }

    public static JMCheckBox createCheckbox(Icon icon, String label, String toolTip, boolean isSelected, boolean isEnabled, Object invocationTarget, String invocationMethod, Object ... invocationMethodArguments) throws IllegalArgumentException {
        JMCheckBox cbx = null;
        cbx = StringUtility.isEmpty(label) ? new JMCheckBox() : new JMCheckBox(label);
        if (StringUtility.isNotEmpty(toolTip)) {
            cbx.setToolTipText(toolTip);
        }
        if (icon != null) {
            cbx.setIcon(icon);
        }
        cbx.setSelected(isSelected);
        cbx.setEnabled(isEnabled);
        if (invocationTarget != null && StringUtility.isEmpty(invocationMethod)) {
            throw new IllegalArgumentException("ComponentFactory.createCheckBox(...):  Invocation target is not null but invocation method is. Cannot invoke a non-existent method.");
        }
        if (invocationTarget != null) {
            if (invocationMethodArguments != null) {
                new ItemEventInvoker(cbx, invocationTarget, invocationMethod, invocationMethodArguments);
            } else {
                new ItemEventInvoker(cbx, invocationTarget, invocationMethod);
            }
        }
        return cbx;
    }

    public static JMButton createButton(Icon icon, String label, String toolTip, boolean isEnabled, Object invocationTarget, String invocationMethod, Object ... invocationMethodArguments) throws IllegalArgumentException {
        JMButton button = null;
        button = StringUtility.isEmpty(label) ? new JMButton() : new JMButton(label);
        if (StringUtility.isNotEmpty(toolTip)) {
            button.setToolTipText(toolTip);
        }
        if (icon != null) {
            button.setIcon(icon);
        }
        button.setEnabled(isEnabled);
        if (invocationTarget != null && StringUtility.isEmpty(invocationMethod)) {
            throw new IllegalArgumentException("ComponentFactory.createButton(...):  Invocation target is not null but invocation method is. Cannot invoke a non-existent method.");
        }
        if (invocationTarget != null) {
            if (invocationMethodArguments != null) {
                new ActionEventInvoker(button, invocationTarget, invocationMethod, invocationMethodArguments);
            } else {
                new ActionEventInvoker(button, invocationTarget, invocationMethod);
            }
        }
        return button;
    }

    public static JMTextField createTextField(String defaultText, int width, int height, Object changeTarget, String changeMethodName, Object ... invocationMethodArguments) {
        JMTextField textField = null;
        textField = defaultText == null ? new JMTextField() : new JMTextField(defaultText);
        textField.setPreferredSize(width, height);
        if (changeTarget != null && StringUtility.isEmpty(changeMethodName)) {
            throw new IllegalArgumentException("ComponentFactory.createTextField(...):  Change target is not null but change method is. Cannot invoke a non-existent method.");
        }
        if (changeTarget != null) {
            if (invocationMethodArguments != null) {
                new PropertyChangeInvoker(textField, changeTarget, changeMethodName, invocationMethodArguments);
            } else {
                new PropertyChangeInvoker(textField, changeTarget, changeMethodName);
            }
        }
        return textField;
    }

    public static JMRadioButton createRadioButton(Icon icon, String label, String toolTip, boolean isSelected, Object eventTarget, String eventMethodName, Object ... invocationMethodArguments) {
        JMRadioButton radioButton = null;
        radioButton = StringUtility.isEmpty(label) ? new JMRadioButton() : new JMRadioButton(label);
        if (StringUtility.isNotEmpty(toolTip)) {
            radioButton.setToolTipText(toolTip);
        }
        if (icon != null) {
            radioButton.setIcon(icon);
        }
        radioButton.setSelected(isSelected);
        if (eventTarget != null && StringUtility.isEmpty(eventMethodName)) {
            throw new IllegalArgumentException("ComponentFactory.createRadioButton(...):  Event target is not null but event method is. Cannot invoke a non-existent method.");
        }
        if (eventTarget != null) {
            if (invocationMethodArguments != null) {
                new ActionEventInvoker(radioButton, eventTarget, eventMethodName, invocationMethodArguments);
            } else {
                new ActionEventInvoker(radioButton, eventTarget, eventMethodName);
            }
        }
        return radioButton;
    }

    public static JMMenuItem createMenuItem(String label, Object eventTarget, String eventMethodName) {
        return ComponentFactory.createMenuItem(label, null, eventTarget, eventMethodName, null);
    }

    public static JMMenuItem createMenuItem(Icon icon, Object eventTarget, String eventMethodName) {
        return ComponentFactory.createMenuItem(null, icon, eventTarget, eventMethodName, null);
    }

    public static JMMenuItem createMenuItem(String label, Icon icon, Object eventTarget, String eventMethodName) {
        return ComponentFactory.createMenuItem(label, icon, eventTarget, eventMethodName, null);
    }

    public static JMMenuItem createMenuItem(String label, Object eventTarget, String eventMethodName, Object ... eventArguments) {
        return ComponentFactory.createMenuItem(label, null, eventTarget, eventMethodName, eventArguments);
    }

    public static JMMenuItem createMenuItem(Icon icon, Object eventTarget, String eventMethodName, Object ... eventArguments) {
        return ComponentFactory.createMenuItem(null, icon, eventTarget, eventMethodName, eventArguments);
    }

    public static JMMenuItem createMenuItem(String label, Icon icon, Object eventTarget, String eventMethodName, Object ... eventArguments) {
        JMMenuItem menuItem = null;
        menuItem = label == null ? new JMMenuItem(icon) : (icon == null ? new JMMenuItem(label) : new JMMenuItem(label, icon));
        if (eventTarget != null && StringUtility.isEmpty(eventMethodName)) {
            throw new IllegalArgumentException("ComponentFactory.createMenuItem(...):  Event target is not null but event method is. Cannot invoke a non-existent method.");
        }
        if (eventTarget != null) {
            if (ArrayUtility.isEmpty(eventArguments)) {
                new ActionEventInvoker(menuItem, eventTarget, eventMethodName);
            } else {
                new ActionEventInvoker(menuItem, eventTarget, eventMethodName, eventArguments);
            }
        }
        return menuItem;
    }

    public static Component createSpacer(int width, int height) {
        JMPanel spacer = new JMPanel();
        spacer.setPreferredSize(width, height);
        spacer.setSize(width, height);
        return spacer;
    }

    public static PropertyChangeSupport textComponentInitHelper(JTextComponent component, String componentName, String shapeCreatorKey) {
        component.setName(componentName);
        HashSet<AWTKeyStroke> forwardTraversalKeys = new HashSet<AWTKeyStroke>();
        forwardTraversalKeys.add(AWTKeyStroke.getAWTKeyStroke(10, 128));
        forwardTraversalKeys.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        component.setFocusTraversalKeys(0, forwardTraversalKeys);
        HashSet reverseTraversalKeys = new HashSet();
        forwardTraversalKeys.add(AWTKeyStroke.getAWTKeyStroke(9, 64));
        component.setFocusTraversalKeys(1, reverseTraversalKeys);
        JTextComponent.KeyBinding[] defaultBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(67, 128), "copy-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(86, 128), "paste-from-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(88, 128), "cut-to-clipboard")};
        Keymap k = component.getKeymap();
        JTextComponent.loadKeymap(k, defaultBindings, component.getActions());
        new KeyEventInvoker((Object)component, 402, component, "setNull", false);
        Document doc = component.getDocument();
        UndoManager undoManager = new UndoManager();
        doc.addUndoableEditListener(undoManager);
        MethodInvoker setUndoManagerMethod = new MethodInvoker((Object)component, "setUndoManager", undoManager);
        setUndoManagerMethod.invoke();
        ShapeCreator shapeCreator = (ShapeCreator)UIManager.get(shapeCreatorKey);
        if (shapeCreator != null) {
            MethodInvoker setShapeCreatorMethod = new MethodInvoker((Object)component, "setShapeCreator", shapeCreator);
            setShapeCreatorMethod.invoke();
        }
        return new PropertyChangeSupport(component);
    }
}

