/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.component;

import com.jmorgan.lang.AsynchMethodInvoker;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class MirrorComponent
extends JComponent {
    private Component sourceComponent;
    private float fadeHeight;
    private float startingTransparency;
    private float endingTransparency;
    private Color surfaceColor;
    private int gap;
    private int updateSpeed;
    private AsynchMethodInvoker<Void> repaintInvoker;

    public MirrorComponent() {
        this.setFadeHeight(0.3f);
        this.setStartingTransparency(0.2f);
        this.setEndingTransparency(1.0f);
        this.setGap(10);
        this.setUpdateSpeed(100);
    }

    public MirrorComponent(Component sourceComponent) {
        this();
        this.setSourceComponent(sourceComponent);
    }

    public Component getSourceComponent() {
        return this.sourceComponent;
    }

    public void setSourceComponent(Component sourceComponent) {
        this.sourceComponent = sourceComponent;
        this.setSurfaceColor(this.sourceComponent.getBackground());
    }

    public Color getSurfaceColor() {
        return this.surfaceColor;
    }

    public void setSurfaceColor(Color surfaceColor) {
        this.surfaceColor = surfaceColor.brighter();
    }

    public float getFadeHeight() {
        return this.fadeHeight;
    }

    public void setFadeHeight(float fadeHeight) {
        this.fadeHeight = fadeHeight;
    }

    public float getStartingTransparency() {
        return this.startingTransparency;
    }

    public void setStartingTransparency(float opacity) {
        this.startingTransparency = opacity;
    }

    public float getEndingTransparency() {
        return this.endingTransparency;
    }

    public void setEndingTransparency(float opacity) {
        this.endingTransparency = opacity;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public int getUpdateSpeed() {
        return this.updateSpeed;
    }

    public void setUpdateSpeed(int updateSpeed) {
        this.updateSpeed = updateSpeed;
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.repaintInvoker != null) {
            this.repaintInvoker.cancel();
        }
        if (!this.shouldRepaint()) {
            return;
        }
        super.paintComponent(g);
        Graphics2D rg = (Graphics2D)g.create();
        Dimension compSize = this.sourceComponent.getSize();
        rg.translate(0, compSize.height + this.gap);
        rg.scale(1.0, -1.0);
        this.sourceComponent.printAll(rg);
        rg.setComposite(AlphaComposite.getInstance(10));
        float[] surfaceColors = this.surfaceColor.getComponents(null);
        Color startColor = new Color(surfaceColors[0], surfaceColors[1], surfaceColors[2], this.endingTransparency);
        Color endColor = new Color(surfaceColors[0], surfaceColors[1], surfaceColors[2], this.startingTransparency);
        GradientPaint fadePaint = new GradientPaint(0.0f, (float)compSize.height * this.fadeHeight, startColor, 0.0f, compSize.height, endColor);
        rg.setPaint(fadePaint);
        rg.fillRect(0, 0, compSize.width, compSize.height + this.gap);
        rg.dispose();
        this.repaintInvoker = new AsynchMethodInvoker((Object)this, "repaint", this.updateSpeed);
    }

    private boolean shouldRepaint() {
        return this.sourceComponent.isVisible() && this.isVisible() && this.sourceComponent.isDisplayable() && this.isDisplayable() && this.sourceComponent.isShowing() && this.isShowing();
    }
}

