/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.component;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.PropertyChangeInvoker;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMSlider;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.component.DefaultNumberConverter;
import com.jmorgan.swing.component.NumberConverter;
import com.jmorgan.swing.event.ChangeEventInvoker;
import com.jmorgan.swing.event.SpinEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.slider.LogarithmicRangeModelDelegate;
import com.jmorgan.swing.spinner.NumberSpinner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;

public class NumericalSliderComponent
extends JMPanel {
    public static final int LAYOUT_HORIZONTAL_SLIDER_FIRST = 0;
    public static final int LAYOUT_HORIZONTAL_NUMBER_FIRST = 1;
    public static final int LAYOUT_VERTICAL_SLIDER_FIRST = 2;
    public static final int LAYOUT_VERTICAL_NUMBER_FIRST = 3;
    public static final int LAYOUT_SPLIT_SLIDER_FIRST = 4;
    public static final int LAYOUT_SPLIT_NUMBER_FIRST = 5;
    public static final int LAYOUT_SPLIT_SLIDER_BOTTOM = 6;
    private JMLabel label;
    private JMSlider slider;
    private NumberField numberField;
    private NumberSpinner numberSpinner;
    private NumberConverter numberConverter;
    private LogarithmicRangeModelDelegate sliderDelegate;
    private int layoutStyle;
    private boolean valueIsChanging;

    public NumericalSliderComponent() {
        this("Label", 0, 0, Integer.MAX_VALUE, 0);
    }

    public NumericalSliderComponent(String label) {
        this(label, 0, 0, Integer.MAX_VALUE, 0);
    }

    public NumericalSliderComponent(String label, int layoutStyle) {
        this(label, 0, 0, Integer.MAX_VALUE, layoutStyle);
    }

    public NumericalSliderComponent(String label, int value, int layoutStyle) {
        this(label, value, 0, Integer.MAX_VALUE, layoutStyle);
    }

    public NumericalSliderComponent(String label, int value, int beginRange, int endRange, int layoutStyle) {
        this.setOpaque(false);
        this.layoutStyle = -1;
        this.setName(label);
        this.setNumberConverter(new DefaultNumberConverter());
        this.slider = new JMSlider(0, beginRange, endRange, value);
        this.slider.setOpaque(false);
        this.slider.setToolTipText("" + value);
        this.add((Component)this.slider, "Center");
        this.numberField = new NumberField((double)value);
        this.numberField.setFormatString("#,##0;-#,##0");
        this.label = new JMLabel(label, this.numberField);
        this.numberSpinner = new NumberSpinner(this.numberField, 1.0, beginRange, endRange);
        this.setLayoutStyle(layoutStyle);
        new AsynchMethodInvoker((Object)this, "setupEventHandling", 250);
    }

    @Reflected
    void setupEventHandling() {
        new ChangeEventInvoker(this.slider, this, "synchNumberToSlider");
        new PropertyChangeInvoker(this.numberField, this, "synchSliderToNumber");
        new SpinEventInvoker((Object)this.numberSpinner, 3, this, "synchSliderToNumber");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.label.setEnabled(enabled);
        this.slider.setEnabled(enabled);
        this.numberField.setEnabled(enabled);
        this.numberSpinner.setEnabled(enabled);
    }

    public void setLogarithmicScale(int min, int max) {
        this.sliderDelegate = new LogarithmicRangeModelDelegate(this.slider, min, max);
        this.numberSpinner.setSpinMinimum(min);
        this.numberSpinner.setSpinMaximum(max);
    }

    public LogarithmicRangeModelDelegate getSliderDelegate() {
        return this.sliderDelegate;
    }

    public NumberConverter getNumberConverter() {
        return this.numberConverter;
    }

    public void setNumberConverter(NumberConverter numberConverter) {
        this.numberConverter = numberConverter == null ? new DefaultNumberConverter() : numberConverter;
    }

    public int getLayoutStyle() {
        return this.layoutStyle;
    }

    public void setLayoutStyle(int layoutStyle) {
        if (this.layoutStyle != -1) {
            this.remove(this.label);
            this.remove(this.numberSpinner);
            this.remove(this.slider);
        }
        this.layoutStyle = -1;
        switch (layoutStyle) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                this.layoutStyle = layoutStyle;
                this.setLayout(new BorderLayout(5, 5));
                break;
            }
            case 2: 
            case 3: {
                this.layoutStyle = layoutStyle;
                this.setLayout(new VerticalFlowLayout(3, 5));
            }
        }
        switch (layoutStyle) {
            case 0: 
            case 1: {
                this.layoutHorizontal(layoutStyle);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.layoutSplit(layoutStyle);
                break;
            }
            case 2: 
            case 3: {
                this.layoutVertical(layoutStyle);
            }
        }
    }

    private void layoutHorizontal(int layoutStyle) {
        this.add((Component)this.label, "West");
        this.add((Component)this.numberSpinner, layoutStyle == 1 ? "Center" : "East");
        this.add((Component)this.slider, layoutStyle == 1 ? "East" : "Center");
    }

    private void layoutVertical(int layoutStyle) {
        this.add(this.label);
        this.add(layoutStyle == 3 ? this.numberSpinner : this.slider);
        this.add(layoutStyle == 3 ? this.slider : this.numberSpinner);
    }

    private void layoutSplit(int layoutStyle) {
        this.add((Component)this.label, layoutStyle == 6 ? "West" : "North");
        this.add((Component)this.slider, layoutStyle == 6 ? "South" : "Center");
        String layoutPosition = "";
        switch (layoutStyle) {
            case 5: {
                layoutPosition = "West";
                break;
            }
            case 4: {
                layoutPosition = "East";
                break;
            }
            case 6: {
                layoutPosition = "Center";
            }
        }
        this.add((Component)this.numberSpinner, layoutPosition);
    }

    public JMLabel getLabel() {
        return this.label;
    }

    public JMSlider getSlider() {
        return this.slider;
    }

    public NumberField getNumberField() {
        return this.numberField;
    }

    public NumberSpinner getSpinner() {
        return this.numberSpinner;
    }

    public void setLabel(String label) {
        this.label.setText(label);
    }

    public void setLabelWidth(int width) {
        Dimension labelSize = this.label.getPreferredSize();
        labelSize.width = width;
        this.label.setPreferredSize(labelSize);
    }

    public void setValueWidth(int width) {
        Dimension valueSize = this.numberField.getPreferredSize();
        valueSize.width = width;
        this.numberField.setPreferredSize(valueSize);
    }

    public double getValue() {
        return this.numberField.getNumber();
    }

    private int getSliderValue() {
        return this.sliderDelegate == null ? this.slider.getValue() : (int)this.sliderDelegate.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(double value) {
        NumberField numberField = this.numberField;
        synchronized (numberField) {
            this.numberField.setNumber(value);
            this.slider.setValue((int)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflected
    public void synchSliderToNumber() {
        int newSliderValue;
        if (this.valueIsChanging) {
            return;
        }
        this.valueIsChanging = true;
        double actualNumberValue = this.numberField.getNumber();
        int actualSliderValue = this.getSliderValue();
        if (actualSliderValue != (newSliderValue = this.numberConverter.getSliderValue(actualNumberValue))) {
            ChangeListener changeListener;
            if (this.sliderDelegate == null) {
                changeListener = this.slider;
                synchronized (changeListener) {
                    this.slider.setValue(newSliderValue);
                }
            }
            changeListener = this.sliderDelegate;
            synchronized (changeListener) {
                this.sliderDelegate.setValue(newSliderValue);
            }
            changeListener = this.slider;
            synchronized (changeListener) {
                this.slider.setToolTipText(this.numberField.getText());
            }
            this.firePropertyChange(this.getName(), new Double(actualSliderValue), new Double(newSliderValue));
        }
        this.valueIsChanging = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflected
    public void synchNumberToSlider() {
        double newNumberValue;
        if (this.valueIsChanging) {
            return;
        }
        this.valueIsChanging = true;
        int actualSliderValue = this.getSliderValue();
        double actualNumberValue = this.numberField.getNumber();
        if (actualNumberValue != (newNumberValue = this.numberConverter.getNumberValue(actualSliderValue))) {
            JComponent jComponent = this.numberField;
            synchronized (jComponent) {
                this.numberField.setNumber(newNumberValue);
            }
            jComponent = this.slider;
            synchronized (jComponent) {
                this.slider.setToolTipText(this.numberField.getText());
            }
            this.firePropertyChange(this.getName(), new Double(actualNumberValue), new Double(newNumberValue));
        }
        this.valueIsChanging = false;
    }
}

