/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.customizer;

import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.swing.JMPanel;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;

public abstract class AbstractCustomizer<T, ET>
extends JMPanel
implements Customizer {
    private PropertyChangeSupport propertyChangeSupport;
    private String propertyName;
    private T object;
    private ET editor;

    public AbstractCustomizer() {
        this(new FlowLayout());
    }

    public AbstractCustomizer(LayoutManager layout) {
        super(layout);
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), propertyName));
    }

    public ET getEditor() {
        return this.editor;
    }

    public void setEditor(ET editor) {
        this.editor = editor;
    }

    public T getObject() {
        return this.object;
    }

    @Override
    public void setObject(Object bean) {
        T oldObject = this.object;
        this.object = bean;
        if (oldObject == null && this.object != null || oldObject != null && this.object == null || oldObject != null && !oldObject.equals(this.object)) {
            this.propertyChangeSupport.firePropertyChange(this.propertyName, oldObject, this.object);
        }
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

