/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.customizer;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.PropertyChangeInvoker;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.component.NumericalSliderComponent;
import com.jmorgan.swing.customizer.AbstractCustomizer;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JSeparator;

public class ColorCustomizer
extends AbstractCustomizer<Color, NumericalSliderComponent[]> {
    private JMPanel colorRenderer = new JMPanel();
    private NumericalSliderComponent redValue;
    private NumericalSliderComponent greenValue;
    private NumericalSliderComponent blueValue;
    private NumericalSliderComponent alphaValue;

    public ColorCustomizer() {
        super(new BorderLayout(5, 5));
        this.colorRenderer.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.colorRenderer.setOpaque(true);
        this.colorRenderer.setPreferredSize(200, 100);
        this.add((Component)this.colorRenderer, "North");
        this.redValue = this.getSlider("Red");
        this.greenValue = this.getSlider("Green");
        this.blueValue = this.getSlider("Blue");
        this.alphaValue = this.getSlider("Alpha");
        JMPanel sliderPanel = new JMPanel(new VerticalFlowLayout(3));
        sliderPanel.add(this.redValue);
        sliderPanel.add(new JSeparator());
        sliderPanel.add(this.greenValue);
        sliderPanel.add(new JSeparator());
        sliderPanel.add(this.blueValue);
        sliderPanel.add(new JSeparator());
        sliderPanel.add(this.alphaValue);
        this.add((Component)sliderPanel, "Center");
        this.setEditor(new NumericalSliderComponent[]{this.redValue, this.greenValue, this.blueValue, this.alphaValue});
    }

    public ColorCustomizer(Color color) {
        this();
        this.setColor(color);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.redValue.setEnabled(enabled);
        this.greenValue.setEnabled(enabled);
        this.blueValue.setEnabled(enabled);
        this.alphaValue.setEnabled(enabled);
    }

    public Color getColor() {
        return (Color)this.getObject();
    }

    @Override
    public void setObject(Object bean) {
        this.setColor((Color)bean);
    }

    public void setColor(Color color) {
        this.redValue.setValue(color.getRed());
        this.greenValue.setValue(color.getGreen());
        this.blueValue.setValue(color.getBlue());
        this.alphaValue.setValue(color.getAlpha());
        this.colorRenderer.setBackground(color);
        super.setObject(color);
    }

    private NumericalSliderComponent getSlider(String label) {
        NumericalSliderComponent comp = new NumericalSliderComponent(label, 0, 0, 255, 6);
        comp.getLabel().setPreferredSize(50, 20);
        comp.getLabel().setHorizontalAlignment(4);
        new PropertyChangeInvoker(comp, this, "renderColor");
        return comp;
    }

    @Reflected
    public synchronized void renderColor() {
        int red = (int)this.redValue.getValue();
        int green = (int)this.greenValue.getValue();
        int blue = (int)this.blueValue.getValue();
        int alpha = (int)this.alphaValue.getValue();
        if (red < 0 || red > 255) {
            red = ColorCustomizer.repairColor(red);
        }
        if (green < 0 || green > 255) {
            green = ColorCustomizer.repairColor(green);
        }
        if (blue < 0 || blue > 255) {
            blue = ColorCustomizer.repairColor(blue);
        }
        if (alpha < 0 || alpha > 255) {
            alpha = ColorCustomizer.repairColor(alpha);
        }
        Color newColor = new Color(red, green, blue, alpha);
        this.colorRenderer.setBackground(newColor);
        super.setObject(newColor);
    }

    private static int repairColor(int color) {
        if (color < 0) {
            return 0;
        }
        return 255;
    }
}

